/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.compat.rei;

import io.wispforest.accessories.client.gui.AccessoriesExperimentalScreen;
import io.wispforest.accessories.client.gui.AccessoriesScreen;
import io.wispforest.accessories.client.gui.components.ArrowComponent;
import io.wispforest.accessories.menu.variants.AccessoriesMenu;
import io.wispforest.accessories.mixin.client.AbstractContainerScreenAccessor;
import io.wispforest.owo.ui.component.ButtonComponent;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.plugin.autocrafting.InventoryCraftingTransferHandler;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class AccessoriesClientREIPlugin
implements REIClientPlugin {
    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(AccessoriesScreen.class, screen -> {
            int leftPos = screen.leftPos();
            int topPos = screen.topPos();
            boolean bl = ((AccessoriesMenu)screen.getMenu()).showingSlots();
            int x = leftPos - screen.getPanelWidth() - (bl ? 15 : 0);
            int y = topPos;
            int width = screen.getPanelWidth() + (bl ? 15 : 0) + 176;
            int height = screen.getPanelHeight();
            return List.of(new Rectangle(x, y, width, height));
        });
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerContainerClickArea(screen -> {
            ArrowComponent component;
            AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)((Object)screen);
            if (screen.showCraftingGrid() && (component = screen.component(ArrowComponent.class, "crafting_arrow")) != null) {
                return new Rectangle(component.x() - accessor.accessories$leftPos(), component.y() - accessor.accessories$topPos(), component.width(), component.height());
            }
            return new Rectangle(0, 0, 0, 0);
        }, AccessoriesExperimentalScreen.class, new CategoryIdentifier[]{BuiltinPlugin.CRAFTING});
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        SimpleTransferHandler transferHandler = new SimpleTransferHandler(this){
            private final CategoryIdentifier<?> categoryIdentifier = BuiltinPlugin.CRAFTING;
            private final SimpleTransferHandler.IntRange inputSlots = new SimpleTransferHandler.IntRange(1, 5);

            public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
                AbstractContainerScreen abstractContainerScreen;
                if (this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) && (abstractContainerScreen = context.getContainerScreen()) instanceof AccessoriesExperimentalScreen) {
                    AccessoriesExperimentalScreen screen = (AccessoriesExperimentalScreen)abstractContainerScreen;
                    if (!screen.showCraftingGrid() && context.isActuallyCrafting()) {
                        ButtonComponent component = screen.component(ButtonComponent.class, "crafting_grid_button");
                        component.onPress();
                    }
                    return TransferHandler.ApplicabilityResult.createApplicable();
                }
                return TransferHandler.ApplicabilityResult.createNotApplicable();
            }

            public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
                return IntStream.range(this.inputSlots.min(), this.inputSlots.maxExclusive()).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().getSlot(id))).toList();
            }

            public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
                LocalPlayer player = context.getMinecraft().player;
                return IntStream.range(0, player.getInventory().items.size()).mapToObj(index -> SlotAccessor.fromPlayerInventory((Player)player, (int)index)).collect(Collectors.toList());
            }
        };
        registry.register((TransferHandler)new InventoryCraftingTransferHandler(transferHandler));
    }
}

