/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.SoundEventData;
import io.wispforest.accessories.api.events.extra.ExtraEventHandler;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.pond.AccessoriesAPIAccess;
import io.wispforest.accessories.pond.AccessoriesLivingEntityExtension;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements AccessoriesAPIAccess,
AccessoriesLivingEntityExtension {
    @Unique
    private AccessoriesCapabilityImpl capability = null;

    protected LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private AccessoriesCapability getOrCreateAccessoriesCapability() {
        if (this.capability == null) {
            this.capability = new AccessoriesCapabilityImpl((LivingEntity)this);
        }
        return this.capability;
    }

    @Override
    @Nullable
    public AccessoriesCapability accessoriesCapability() {
        Map<String, SlotType> slots = EntitySlotLoader.getEntitySlots((LivingEntity)this);
        if (slots.isEmpty()) {
            return null;
        }
        AccessoriesCapability capability = this.getOrCreateAccessoriesCapability();
        capability.getHolder();
        return capability;
    }

    @Override
    @Nullable
    public AccessoriesHolder accessoriesHolder() {
        AccessoriesCapability capability = this.getOrCreateAccessoriesCapability();
        return capability != null ? capability.getHolder() : null;
    }

    @Inject(method={"onEquippedItemBroken(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/entity/EquipmentSlot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendAccessoriesBreakInstead(Item item, EquipmentSlot slot, CallbackInfo ci) {
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT)) {
            ci.cancel();
        }
    }

    @Inject(method={"entityEventForEquipmentBreak(Lnet/minecraft/world/entity/EquipmentSlot;)B"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventMatchExceptionForAccessories(EquipmentSlot slot, CallbackInfoReturnable<Byte> cir) {
        if (slot.equals((Object)AccessoriesInternals.INTERNAL_SLOT)) {
            cir.setReturnValue((Object)-1);
        }
    }

    @Override
    public void onEquipItem(SlotReference slotReference, ItemStack oldItem, ItemStack newItem) {
        Level level = this.level();
        if (!(ItemStack.isSameItemSameComponents((ItemStack)oldItem, (ItemStack)newItem) || this.firstTick || level.isClientSide() || this.isSpectator())) {
            SoundEventData sound;
            boolean isEquitableFor;
            boolean bl = isEquitableFor = newItem.isEmpty() || AccessoriesAPI.canInsertIntoSlot(newItem, slotReference);
            if (!this.isSilent() && !newItem.isEmpty() && (sound = AccessoriesAPI.getOrDefaultAccessory(newItem).getEquipSound(newItem, slotReference)) != null) {
                level.playSeededSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)sound.event().value(), this.getSoundSource(), sound.volume(), sound.pitch(), this.random.nextLong());
            }
            if (isEquitableFor) {
                this.gameEvent((Holder)(!newItem.isEmpty() ? GameEvent.EQUIP : GameEvent.UNEQUIP));
            }
        }
    }

    @ModifyReturnValue(method={"canFreeze()Z"}, at={@At(value="RETURN", ordinal=1)})
    private boolean canFreezeAccessoriesCheck(boolean bl) {
        TriState state = ExtraEventHandler.canFreezeEntity((LivingEntity)this);
        return state.orElse(bl);
    }
}

