/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.slf4j.Logger;

public class AttributeUtils {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final StructEndec<AttributeModifier> ATTRIBUTE_MODIFIER_ENDEC = StructEndecBuilder.of((StructField)MinecraftEndecs.IDENTIFIER.fieldOf("id", AttributeModifier::id), (StructField)Endec.DOUBLE.fieldOf("amount", AttributeModifier::amount), (StructField)EndecUtils.forEnumStringRepresentable(AttributeModifier.Operation.class).fieldOf("operation", AttributeModifier::operation), AttributeModifier::new);

    public static void addTransientAttributeModifiers(LivingEntity livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        AttributeMap attributeMap = livingEntity.getAttributes();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !container.hasModifier(modifier.id())).forEach(container::addTransientModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            AttributeInstance instance = attributeMap.getInstance(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().filter(modifier -> !instance.hasModifier(modifier.id())).forEach(arg_0 -> ((AttributeInstance)instance).addTransientModifier(arg_0));
        });
    }

    public static void removeTransientAttributeModifiers(LivingEntity livingEntity, AccessoryAttributeBuilder attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        AttributeMap attributeMap = livingEntity.getAttributes();
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        attributes.getSlotModifiers().asMap().forEach((s, modifiers) -> {
            AccessoriesContainer container = (AccessoriesContainer)containers.get(s);
            if (container == null) {
                return;
            }
            modifiers.stream().map(AttributeModifier::id).forEach(container::removeModifier);
        });
        attributes.getAttributeModifiers(true).asMap().forEach((holder, modifiers) -> {
            AttributeInstance instance = attributeMap.getInstance(holder);
            if (instance == null) {
                return;
            }
            modifiers.stream().map(AttributeModifier::id).forEach(arg_0 -> ((AttributeInstance)instance).removeModifier(arg_0));
        });
    }
}

