/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup.gui;

import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;

public final class ItemGroupButton
implements OwoItemGroup.ButtonDefinition {
    public static final ResourceLocation ICONS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"owo", (String)"textures/gui/icons.png");
    private final Icon icon;
    private final Component tooltip;
    private final ResourceLocation texture;
    private final Runnable action;

    public ItemGroupButton(CreativeModeTab group, Icon icon, String name, ResourceLocation texture, Runnable action) {
        this.icon = icon;
        this.tooltip = OwoItemGroup.ButtonDefinition.tooltipFor(group, "button", name);
        this.action = action;
        this.texture = texture;
    }

    public ItemGroupButton(CreativeModeTab group, Icon icon, String name, Runnable action) {
        this(group, icon, name, ItemGroupTab.DEFAULT_TEXTURE, action);
    }

    public static ItemGroupButton github(CreativeModeTab group, String url) {
        return ItemGroupButton.link(group, Icon.of(ICONS_TEXTURE, 0, 0, 64, 64), "github", url);
    }

    public static ItemGroupButton modrinth(CreativeModeTab group, String url) {
        return ItemGroupButton.link(group, Icon.of(ICONS_TEXTURE, 16, 0, 64, 64), "modrinth", url);
    }

    public static ItemGroupButton curseforge(CreativeModeTab group, String url) {
        return ItemGroupButton.link(group, Icon.of(ICONS_TEXTURE, 32, 0, 64, 64), "curseforge", url);
    }

    public static ItemGroupButton discord(CreativeModeTab group, String url) {
        return ItemGroupButton.link(group, Icon.of(ICONS_TEXTURE, 48, 0, 64, 64), "discord", url);
    }

    public static ItemGroupButton link(CreativeModeTab group, Icon icon, String name, String url) {
        return new ItemGroupButton(group, icon, name, () -> {
            Minecraft client = Minecraft.getInstance();
            Screen screen = client.screen;
            client.setScreen((Screen)new ConfirmLinkScreen(confirmed -> {
                if (confirmed) {
                    Util.getPlatform().openUri(url);
                }
                client.setScreen(screen);
            }, url, true));
        });
    }

    @Override
    public ResourceLocation texture() {
        return this.texture;
    }

    @Override
    public Icon icon() {
        return this.icon;
    }

    @Override
    public Component tooltip() {
        return this.tooltip;
    }

    public Runnable action() {
        return this.action;
    }
}

