/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.paladins.client.armor.PaladinArmorRenderer;
import net.paladins.client.armor.PriestArmorRenderer;
import net.paladins.client.effect.DivineProtectionRenderer;
import net.paladins.client.entity.BannerEntityRenderer;
import net.paladins.client.entity.BarrierEntityRenderer;
import net.paladins.effect.PaladinEffects;
import net.paladins.entity.BannerEntity;
import net.paladins.entity.BarrierEntity;
import net.paladins.item.armor.Armors;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.BuffParticleSpawner;
import net.spell_engine.api.render.CustomModels;
import net.spell_engine.api.render.StunParticleSpawner;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;

public class PaladinsClientMod {
    public static void init() {
        CustomModels.registerModelIds(List.of(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"projectile/judgement"), DivineProtectionRenderer.modelId_base, DivineProtectionRenderer.modelId_overlay, BannerEntityRenderer.modelId));
        CustomModelStatusEffect.register((MobEffect)PaladinEffects.DIVINE_PROTECTION.effect, (CustomModelStatusEffect.Renderer)new DivineProtectionRenderer());
        CustomParticleStatusEffect.register((MobEffect)PaladinEffects.JUDGEMENT.effect, (CustomParticleStatusEffect.Spawner)new StunParticleSpawner());
        CustomParticleStatusEffect.register((MobEffect)PaladinEffects.ABSORPTION.effect, (CustomParticleStatusEffect.Spawner)new BuffParticleSpawner(new ParticleBatch(SpellEngineParticles.aura_effect_553.id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).scale(1.4f).followEntity(true).color(Color.HOLY.alpha(0.75f).toRGBA())).withFrequency(30).scaleWithAmplifier(false));
        EntityRendererRegistry.register(BarrierEntity.TYPE, BarrierEntityRenderer::new);
        EntityRendererRegistry.register(BannerEntity.ENTITY_TYPE, BannerEntityRenderer::new);
        BarrierEntityRenderer.setup();
        PaladinsClientMod.registerArmorRenderer(Armors.paladinArmorSet_t1, PaladinArmorRenderer::paladin);
        PaladinsClientMod.registerArmorRenderer(Armors.paladinArmorSet_t2, PaladinArmorRenderer::crusader);
        PaladinsClientMod.registerArmorRenderer(Armors.paladinArmorSet_t3, PaladinArmorRenderer::netheriteCrusader);
        PaladinsClientMod.registerArmorRenderer(Armors.priestArmorSet_t1, PriestArmorRenderer::priest);
        PaladinsClientMod.registerArmorRenderer(Armors.priestArmorSet_t2, PriestArmorRenderer::prior);
        PaladinsClientMod.registerArmorRenderer(Armors.priestArmorSet_t3, PriestArmorRenderer::netheritePrior);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

