/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.paladins.content.PaladinSounds;
import net.paladins.effect.DivineProtectionStatusEffect;
import net.paladins.effect.JudgementStatusEffect;
import net.paladins.effect.PriestAbsorptionStatusEffect;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.ActionImpairing;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.EntityActionsAllowed;
import net.spell_engine.api.effect.Protection;
import net.spell_engine.api.effect.Synchronized;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_power.api.SpellPowerMechanics;

public class PaladinEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static final Effects.Entry DIVINE_PROTECTION = PaladinEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"divine_protection"), "Divine Protection", "Protects you from the incoming attack", (MobEffect)new DivineProtectionStatusEffect(MobEffectCategory.BENEFICIAL, 0x66CCFF)));
    public static final Effects.Entry BATTLE_BANNER = PaladinEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"battle_banner"), "Battle Banner", "Increases attack speed, spell haste, and knockback resistance", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 0x66CCFF), new EffectConfig(List.of(new AttributeModifier(Attributes.ATTACK_SPEED.getRegisteredName(), 0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(SpellPowerMechanics.HASTE.id.toString(), 0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.KNOCKBACK_RESISTANCE.getRegisteredName(), 0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"ranged_weapon", (String)"haste").toString(), 0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static final Effects.Entry JUDGEMENT = PaladinEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"judgement"), "Judgement", "Prevents movement and actions", (MobEffect)new JudgementStatusEffect(MobEffectCategory.HARMFUL, 0xFFFFCC), new EffectConfig(List.of(new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), 0.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)))));
    public static final Effects.Entry ABSORPTION = PaladinEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"priest_absorption"), "Absorption", "Increases maximum absorption", (MobEffect)new PriestAbsorptionStatusEffect(MobEffectCategory.BENEFICIAL, 0xFFFFCC), new EffectConfig(List.of(new AttributeModifier(Attributes.MAX_ABSORPTION.getRegisteredName(), 2.0f, AttributeModifier.Operation.ADD_VALUE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        Synchronized.configure((MobEffect)PaladinEffects.DIVINE_PROTECTION.effect, (boolean)true);
        Synchronized.configure((MobEffect)PaladinEffects.JUDGEMENT.effect, (boolean)true);
        Synchronized.configure((MobEffect)PaladinEffects.ABSORPTION.effect, (boolean)true);
        ActionImpairing.configure((MobEffect)PaladinEffects.JUDGEMENT.effect, (EntityActionsAllowed)EntityActionsAllowed.STUN);
        Effects.register(entries, (Map)config.effects);
        Protection.register((Holder)PaladinEffects.DIVINE_PROTECTION.entry, (Protection.Pop)new Protection.Pop(new ParticleBatch[]{DivineProtectionStatusEffect.particles}, PaladinSounds.divine_protection_impact.soundEvent()));
    }
}

