/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.entity;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.paladins.content.PaladinSounds;
import net.spell_engine.api.effect.EntityImmunity;
import net.spell_engine.api.entity.SpellEntity;
import net.spell_engine.api.entity.TwoWayCollisionChecker;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.target.EntityRelation;
import net.spell_engine.internals.target.EntityRelations;
import net.spell_engine.utils.SoundPlayerWorld;
import org.jetbrains.annotations.Nullable;

public class BarrierEntity
extends Entity
implements SpellEntity.Spawned {
    public static EntityType<BarrierEntity> TYPE;
    private ResourceLocation spellId;
    private int ownerId;
    private int timeToLive = 20;
    private static final EntityDataAccessor<String> SPELL_ID_TRACKER;
    private static final EntityDataAccessor<Integer> OWNER_ID_TRACKER;
    private static final EntityDataAccessor<Integer> TIME_TO_LIVE_TRACKER;
    private boolean idleSoundFired = false;
    private static final int checkInterval = 4;
    private LivingEntity cachedOwner = null;

    public BarrierEntity(EntityType<? extends BarrierEntity> entityType, Level world) {
        super(entityType, world);
        ((TwoWayCollisionChecker)this).setReverseCollisionChecker(entity -> this.canCollideWith((Entity)entity) ? TwoWayCollisionChecker.CollisionResult.COLLIDE : TwoWayCollisionChecker.CollisionResult.PASS);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void onSpawnedBySpell(SpellEntity.Spawned.Args args) {
        LivingEntity owner = args.owner();
        ResourceLocation spellId = ((ResourceKey)args.spell().unwrapKey().get()).location();
        Spell.Impact.Action.Spawn spawn = args.spawnData();
        this.spellId = spellId;
        this.getEntityData().set(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.ownerId = owner.getId();
        this.getEntityData().set(OWNER_ID_TRACKER, (Object)this.ownerId);
        this.timeToLive = spawn.time_to_live_seconds * 20;
        this.getEntityData().set(TIME_TO_LIVE_TRACKER, (Object)this.timeToLive);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeHitByProjectile() {
        return this.isAlive();
    }

    public boolean canCollideWith(Entity other) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return super.canCollideWith(other);
        }
        if (other instanceof LivingEntity) {
            LivingEntity otherLiving = (LivingEntity)other;
            return !this.isProtected((Entity)otherLiving);
        }
        return super.canCollideWith(other);
    }

    public boolean hurt(DamageSource source, float amount) {
        this.level().playSound(null, (Entity)this, PaladinSounds.holy_barrier_impact.soundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return super.hurt(source, amount);
    }

    public EntityDimensions getDimensions(Pose pose) {
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry != null) {
            Spell spell = (Spell)spellEntry.value();
            float width = spell.range * 2.0f;
            float height = spell.range;
            return EntityDimensions.scalable((float)width, (float)height);
        }
        return super.getDimensions(pose);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPELL_ID_TRACKER, (Object)"");
        builder.define(OWNER_ID_TRACKER, (Object)0);
        builder.define(TIME_TO_LIVE_TRACKER, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        String rawSpellId = (String)this.getEntityData().get(SPELL_ID_TRACKER);
        if (rawSpellId != null && !rawSpellId.isEmpty()) {
            this.spellId = ResourceLocation.parse((String)rawSpellId);
        }
        this.timeToLive = (Integer)this.getEntityData().get(TIME_TO_LIVE_TRACKER);
        this.refreshDimensions();
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.spellId = ResourceLocation.parse((String)nbt.getString(NBTKey.SPELL_ID.key));
        this.ownerId = nbt.getInt(NBTKey.OWNER_ID.key);
        this.timeToLive = nbt.getInt(NBTKey.TIME_TO_LIVE.key);
        this.getEntityData().set(SPELL_ID_TRACKER, (Object)this.spellId.toString());
        this.getEntityData().set(OWNER_ID_TRACKER, (Object)this.ownerId);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString(NBTKey.SPELL_ID.key, this.spellId.toString());
        nbt.putInt(NBTKey.OWNER_ID.key, this.ownerId);
        nbt.putInt(NBTKey.TIME_TO_LIVE.key, this.timeToLive);
    }

    public boolean isSilent() {
        return false;
    }

    public void tick() {
        super.tick();
        Holder<Spell> spellEntry = this.getSpellEntry();
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.value();
        Level world = this.level();
        if (world.isClientSide()) {
            if (!this.idleSoundFired) {
                ((SoundPlayerWorld)world).playSoundFromEntity((Entity)this, PaladinSounds.holy_barrier_idle.soundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
                this.idleSoundFired = true;
            }
        } else {
            if (this.tickCount > this.timeToLive) {
                this.kill();
            }
            if (this.tickCount % 4 == 0) {
                List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.1f));
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (this.isProtected((Entity)livingEntity)) {
                        EntityImmunity.setImmune((Entity)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.AREA_EFFECT, (int)5);
                        EntityImmunity.setImmune((Entity)livingEntity, (EntityImmunity.Type)EntityImmunity.Type.EXPLOSION, (int)5);
                        continue;
                    }
                    livingEntity.knockback((double)((TweaksConfig)PaladinsMod.tweaksConfig.value).barrier_knockback_strength, this.getX() - livingEntity.getX(), this.getZ() - livingEntity.getZ());
                    if (!(livingEntity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket(serverPlayer.getId(), serverPlayer.getDeltaMovement()), null);
                }
            }
            if (this.tickCount == this.timeToLive - this.expirationDuration()) {
                this.level().playSound(null, (Entity)this, PaladinSounds.holy_barrier_deactivate.soundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public int expirationDuration() {
        return 20;
    }

    public boolean isExpiring() {
        return this.tickCount >= this.timeToLive - this.expirationDuration();
    }

    public boolean isProtected(Entity other) {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        EntityRelation relation = EntityRelations.getRelation((LivingEntity)owner, (Entity)other);
        switch (relation) {
            case ALLY: 
            case FRIENDLY: {
                return true;
            }
            case NEUTRAL: 
            case MIXED: 
            case HOSTILE: {
                return false;
            }
        }
        return false;
    }

    @Nullable
    public Holder<Spell> getSpellEntry() {
        return SpellRegistry.from((Level)this.level()).getHolder(this.spellId).orElse(null);
    }

    @Nullable
    public LivingEntity getOwner() {
        if (this.cachedOwner != null) {
            return this.cachedOwner;
        }
        Entity owner = this.level().getEntity(this.ownerId);
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner;
            this.cachedOwner = livingOwner = (LivingEntity)owner;
            return livingOwner;
        }
        return null;
    }

    static {
        SPELL_ID_TRACKER = SynchedEntityData.defineId(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        OWNER_ID_TRACKER = SynchedEntityData.defineId(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        TIME_TO_LIVE_TRACKER = SynchedEntityData.defineId(BarrierEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    private static enum NBTKey {
        OWNER_ID("OwnerId"),
        SPELL_ID("SpellId"),
        TIME_TO_LIVE("TTL");

        public final String key;

        private NBTKey(String key) {
            this.key = key;
        }
    }
}

