/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.paladins.PaladinsMod;
import net.paladins.config.TweaksConfig;
import net.paladins.content.PaladinSounds;
import net.paladins.item.Group;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ShieldConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.Tiers;
import net.spell_engine.api.item.weapon.Weapon;

public class Shields {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    private static final String GENERIC_ARMOR_TOUGHNESS = "minecraft:generic.armor_toughness";
    private static final String GENERIC_MAX_HEALTH = "generic.max_health";
    private static final int durability_t0 = 168;
    private static final int durability_t1 = 336;
    private static final int durability_t2 = 672;
    private static final int durability_t3 = 1344;
    private static final int durability_t4 = 2688;
    public static Entry iron_kite_shield = Shields.shield("iron_kite_shield", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADD_VALUE)), 336, Equipment.LootProperties.of((int)1));
    public static Entry golden_kite_shield = Shields.shield("golden_kite_shield", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}), List.of(), 168, Equipment.LootProperties.of((String)"golden_weapon"));
    public static Entry diamond_kite_shield = Shields.shield("diamond_kite_shield", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 2.0f, AttributeModifier.Operation.ADD_VALUE)), 672, Equipment.LootProperties.of((int)2));
    public static Entry netherite_kite_shield = Shields.shield("netherite_kite_shield", () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), List.of(new AttributeModifier("minecraft:generic.armor_toughness", 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier("generic.max_health", 4.0f, AttributeModifier.Operation.ADD_VALUE)), 1344, Equipment.LootProperties.of((int)3));
    private static final String AETHER = "aether";
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    public static Entry shield(String name, Supplier<Ingredient> repair, List<AttributeModifier> attributes, int durability, Equipment.LootProperties lootProperties) {
        Entry entry = new Entry(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name), repair, attributes, durability, lootProperties, new Holder());
        ENTRIES.add(entry);
        return entry;
    }

    public static void register(Map<String, ShieldConfig> configs) {
        Supplier<Ingredient> repair;
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_NETHER)) {
            repair = Shields.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            Shields.shield("ruby_kite_shield", repair, List.of(new AttributeModifier(GENERIC_ARMOR_TOUGHNESS, 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADD_VALUE)), 2688, Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(BETTER_END)) {
            repair = Shields.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            Shields.shield("aeternium_kite_shield", repair, List.of(new AttributeModifier(GENERIC_ARMOR_TOUGHNESS, 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADD_VALUE)), 2688, Equipment.LootProperties.of((int)4));
        }
        if (((TweaksConfig)PaladinsMod.tweaksConfig.value).ignore_items_required_mods || FabricLoader.getInstance().isModLoaded(AETHER)) {
            repair = Shields.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            Shields.shield("aether_kite_shield", repair, List.of(new AttributeModifier(GENERIC_ARMOR_TOUGHNESS, 1.0f, AttributeModifier.Operation.ADD_VALUE), new AttributeModifier(GENERIC_MAX_HEALTH, 6.0f, AttributeModifier.Operation.ADD_VALUE)), 2688, Equipment.LootProperties.of((String)AETHER));
        }
        int netheriteTier = Tiers.unsafe((String)"netherite");
        ArrayList<CustomShieldItem> shields = new ArrayList<CustomShieldItem>();
        for (Entry entry : ENTRIES) {
            ShieldConfig config = configs.get(entry.id.toString());
            if (config == null) {
                config = new ShieldConfig();
                config.durability = entry.durability;
                config.attributes = entry.attributes;
                configs.put(entry.id.toString(), config);
            }
            ArrayList<Tuple> shieldAttributes = new ArrayList<Tuple>();
            for (ItemAttributeModifiers.Entry modifier : Weapon.attributesFrom((List)config.attributes).modifiers()) {
                shieldAttributes.add(new Tuple((Object)modifier.attribute(), (Object)modifier.modifier()));
            }
            Item.Properties settings = new Item.Properties().durability(config.durability);
            int tier = entry.lootProperties().tier();
            if (tier >= netheriteTier) {
                settings.fireResistant();
            }
            CustomShieldItem shield = new CustomShieldItem(PaladinSounds.shield_equip.entry(), entry.repair, shieldAttributes, settings);
            entry.holder.item = shield;
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id, (Object)shield);
            shields.add(shield);
        }
        ItemGroupEvents.modifyEntriesEvent(Group.KEY).register(content -> {
            for (Item shield : shields) {
                content.accept((ItemLike)shield);
            }
        });
    }

    public record Entry(ResourceLocation id, Supplier<Ingredient> repair, List<AttributeModifier> attributes, int durability, Equipment.LootProperties lootProperties, Holder holder) {
    }

    public static class Holder {
        public Item item;

        public Holder() {
        }

        public Holder(Item item) {
            this.item = item;
        }
    }
}

