/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.item.armor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.paladins.content.PaladinSounds;
import net.paladins.item.Group;
import net.paladins.item.armor.PaladinArmor;
import net.paladins.item.armor.PriestArmor;
import net.spell_engine.api.config.ArmorSetConfig;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.armor.Armor;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class Armors {
    public static final ArrayList<Armor.Entry> entries = new ArrayList();
    private static final ResourceLocation ATTACK_DAMAGE_ID = ResourceLocation.withDefaultNamespace((String)"generic.attack_damage");
    private static final ResourceLocation ARMOR_TOUGHNESS_ID = ResourceLocation.withDefaultNamespace((String)"generic.armor_toughness");
    public static Holder<ArmorMaterial> paladin_armor = Armors.material("paladin_armor", 2, 6, 5, 2, 9, PaladinSounds.paladin_armor_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT}));
    public static Holder<ArmorMaterial> crusader_armor = Armors.material("crusader_armor", 3, 8, 6, 3, 10, PaladinSounds.paladin_armor_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}));
    public static Holder<ArmorMaterial> netherite_crusader_armor = Armors.material("netherite_crusader_armor", 3, 8, 6, 3, 15, PaladinSounds.paladin_armor_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    public static Holder<ArmorMaterial> priest_robe = Armors.material("priest_robe", 1, 3, 2, 1, 9, PaladinSounds.priest_robe_equip.entry(), () -> Ingredient.of((TagKey)ItemTags.WOOL));
    public static Holder<ArmorMaterial> prior_robe = Armors.material("prior_robe", 1, 3, 2, 1, 10, PaladinSounds.priest_robe_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}));
    public static Holder<ArmorMaterial> netherite_prior_robe = Armors.material("netherite_prior_robe", 1, 3, 2, 1, 15, PaladinSounds.priest_robe_equip.entry(), () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));
    private static final float paladin_t1_spell_power = 0.5f;
    private static final float paladin_t2_spell_power = 1.0f;
    private static final float paladin_t3_spell_power = 1.0f;
    private static final float paladin_t3_toughness = 1.0f;
    public static final Armor.Set paladinArmorSet_t1 = Armors.create(paladin_armor, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"paladin_armor"), 15, PaladinArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)0.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)0.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(5).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)0.5f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)0.5f))), 1).armorSet();
    public static final Armor.Set paladinArmorSet_t2 = Armors.create(crusader_armor, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"crusader_armor"), 25, PaladinArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f))), 2).armorSet();
    public static final Armor.Set paladinArmorSet_t3 = Armors.create(netherite_crusader_armor, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"netherite_crusader_armor"), 37, PaladinArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(Armors.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(8).add(Armors.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(6).add(Armors.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(Armors.toughnessBonus(1.0f)).addAll((List)AttributeModifier.bonuses(List.of(SpellSchools.HEALING.id), (float)1.0f))), 3).armorSet();
    private static final float priest_t1_spell_power = 0.2f;
    private static final float priest_t2_spell_power = 0.25f;
    private static final float priest_t2_haste = 0.03f;
    private static final float priest_t3_spell_power = 0.3f;
    private static final float priest_t3_haste = 0.04f;
    public static final Armor.Set priestArmorSet_t1 = Armors.create(priest_robe, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"priest_robe"), 10, PriestArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.2f)), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).add(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.2f))), 1).armorSet();
    public static final Armor.Set priestArmorSet_t2 = Armors.create(prior_robe, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"prior_robe"), 20, PriestArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.25f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.03f)))), 2).armorSet();
    public static final Armor.Set priestArmorSet_t3 = Armors.create(netherite_prior_robe, ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)"netherite_prior_robe"), 30, PriestArmor::new, ArmorSetConfig.with((ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(3).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(2).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.04f))), (ArmorSetConfig.Piece)new ArmorSetConfig.Piece(1).addAll(List.of(AttributeModifier.multiply((ResourceLocation)SpellSchools.HEALING.id, (float)0.3f), AttributeModifier.multiply((ResourceLocation)SpellPowerMechanics.HASTE.id, (float)0.04f)))), 3).armorSet();

    private static Armor.Entry create(Holder<ArmorMaterial> material, ResourceLocation id, int durability, Armor.Set.ItemFactory factory, ArmorSetConfig defaults, int tier) {
        Armor.Entry entry = Armor.Entry.create(material, (ResourceLocation)id, (int)durability, (Armor.Set.ItemFactory)factory, (ArmorSetConfig)defaults, (Equipment.LootProperties)Equipment.LootProperties.of((int)tier));
        entries.add(entry);
        return entry;
    }

    public static Holder<ArmorMaterial> material(String name, int protectionHead, int protectionChest, int protectionLegs, int protectionFeet, int enchantability, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredient) {
        ArmorMaterial material = new ArmorMaterial(Map.of(ArmorItem.Type.HELMET, protectionHead, ArmorItem.Type.CHESTPLATE, protectionChest, ArmorItem.Type.LEGGINGS, protectionLegs, ArmorItem.Type.BOOTS, protectionFeet), enchantability, equipSound, repairIngredient, List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name))), 0.0f, 0.0f);
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name), (Object)material);
    }

    private static AttributeModifier damageMultiplier(float value) {
        return new AttributeModifier(ATTACK_DAMAGE_ID.toString(), value, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    private static AttributeModifier toughnessBonus(float value) {
        return new AttributeModifier(ARMOR_TOUGHNESS_ID.toString(), value, AttributeModifier.Operation.ADD_VALUE);
    }

    public static void register(Map<String, ArmorSetConfig> configs) {
        Armor.register(configs, entries, Group.KEY);
    }
}

