/*
 * Decompiled with CFR 0.152.
 */
package net.paladins.village;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.paladins.PaladinsMod;
import net.paladins.block.PaladinBlocks;
import net.paladins.content.PaladinSounds;
import net.paladins.item.PaladinWeapons;
import net.paladins.item.armor.Armors;
import net.runes.api.RuneItems;

public class PaladinVillagers {
    public static final String PALADIN_MERCHANT = "monk";

    public static PoiType registerPOI(String name, Block block) {
        return PointOfInterestHelper.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name), (int)1, (int)10, (Iterable)ImmutableSet.copyOf((Collection)block.getStateDefinition().getPossibleStates()));
    }

    public static VillagerProfession registerProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name);
        return (VillagerProfession)Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)name), (Object)new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), PaladinSounds.paladin_armor_equip.soundEvent()));
    }

    public static void registerPOI() {
        if (!FabricLoader.getInstance().isModLoaded("lithostitched")) {
            StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)PaladinsMod.villageConfig.value));
        }
        PaladinVillagers.registerPOI(PALADIN_MERCHANT, PaladinBlocks.MONK_WORKBENCH);
    }

    public static void registerVillagers() {
        VillagerProfession profession = PaladinVillagers.registerProfession(PALADIN_MERCHANT, (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"paladins", (String)PALADIN_MERCHANT)));
        LinkedHashMap<Integer, List<Object>> trades = new LinkedHashMap<Integer, List<Object>>();
        trades.put(1, List.of(new VillagerTrades.ItemsForEmeralds(RuneItems.get((RuneItems.RuneType)RuneItems.RuneType.HEALING), 2, 8, 128, 1, 0.01f), new VillagerTrades.ItemsForEmeralds(PaladinWeapons.acolyte_wand.item(), 4, 1, 12, 5), new VillagerTrades.ItemsForEmeralds(PaladinWeapons.wooden_great_hammer.item(), 8, 1, 12, 8)));
        trades.put(2, List.of(new VillagerTrades.EmeraldForItems((ItemLike)Items.WHITE_WOOL, 5, 12, 5, 8), new VillagerTrades.EmeraldForItems((ItemLike)Items.IRON_INGOT, 6, 12, 5, 8), new VillagerTrades.EmeraldForItems((ItemLike)Items.CHAIN, 6, 12, 5, 8), new VillagerTrades.EmeraldForItems((ItemLike)Items.GOLD_INGOT, 6, 12, 5, 8)));
        trades.put(3, List.of(new VillagerTrades.ItemsForEmeralds((Item)Armors.paladinArmorSet_t1.head, 15, 1, 12, 13), new VillagerTrades.ItemsForEmeralds((Item)Armors.paladinArmorSet_t1.feet, 15, 1, 12, 13), new VillagerTrades.ItemsForEmeralds((Item)Armors.priestArmorSet_t1.head, 15, 1, 12, 13), new VillagerTrades.ItemsForEmeralds((Item)Armors.priestArmorSet_t1.feet, 15, 1, 12, 13)));
        trades.put(4, List.of(new VillagerTrades.ItemsForEmeralds((Item)Armors.paladinArmorSet_t1.chest, 20, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)Armors.paladinArmorSet_t1.legs, 20, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)Armors.priestArmorSet_t1.chest, 20, 1, 12, 15), new VillagerTrades.ItemsForEmeralds((Item)Armors.priestArmorSet_t1.legs, 20, 1, 12, 15)));
        for (Map.Entry entry : trades.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)((Integer)entry.getKey()), factories -> factories.addAll((Collection)entry.getValue()));
        }
        TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)5, factories -> {
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(PaladinWeapons.diamond_holy_staff.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(PaladinWeapons.diamond_claymore.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
            factories.add((entity, random) -> new VillagerTrades.EnchantedItemForEmeralds(PaladinWeapons.diamond_great_hammer.item(), 40, 3, 30, 0.0f).getOffer(entity, random));
        });
    }

    public static void register() {
        PaladinVillagers.registerPOI();
        PaladinVillagers.registerVillagers();
    }
}

