/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.Platform;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.api.component.BetterCombatDataComponents;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.CompressionHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class WeaponRegistry {
    static final Logger LOGGER = LogUtils.getLogger();
    static Map<ResourceLocation, WeaponAttributes> registrations = new HashMap<ResourceLocation, WeaponAttributes>();
    static Map<ResourceLocation, AttributesContainer> containers = new HashMap<ResourceLocation, AttributesContainer>();
    private static Encoded encodedRegistrations = new Encoded(true, List.of());
    private static final int CHUNK_SIZE = 10000;
    private static final Gson gson = new GsonBuilder().create();

    public static void register(ResourceLocation itemId, WeaponAttributes attributes) {
        registrations.put(itemId, attributes);
    }

    static WeaponAttributes getAttributes(ResourceLocation itemId) {
        return registrations.get(itemId);
    }

    public static WeaponAttributes getAttributes(ItemStack itemStack) {
        AttributesContainer container;
        if (itemStack == null) {
            return null;
        }
        ResourceLocation component = (ResourceLocation)itemStack.get(BetterCombatDataComponents.WEAPON_PRESET_ID);
        if (component != null && (container = containers.get(component)) != null) {
            return container.attributes();
        }
        Item item = itemStack.getItem();
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return WeaponRegistry.getAttributes(id);
    }

    public static void loadAttributes(ResourceManager resourceManager) {
        WeaponRegistry.loadContainers(resourceManager);
        containers.forEach((itemId, container) -> {
            if (!BuiltInRegistries.ITEM.containsKey(itemId)) {
                return;
            }
            WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
        });
    }

    private static void loadContainers(ResourceManager resourceManager) {
        HashMap<ResourceLocation, AttributesContainer> containers = new HashMap<ResourceLocation, AttributesContainer>();
        for (Map.Entry entry : resourceManager.listResources("weapon_attributes", fileName -> fileName.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.open()));
                AttributesContainer container = WeaponAttributesHelper.decode(reader);
                String id = identifier.toString().replace("weapon_attributes/", "");
                id = id.substring(0, id.lastIndexOf(46));
                containers.put(ResourceLocation.parse((String)id), container);
                System.out.println("Loaded container: " + id);
            }
            catch (Exception e) {
                System.err.println("Failed to parse: " + String.valueOf(identifier));
                e.printStackTrace();
            }
        }
        WeaponRegistry.containers = containers;
        HashMap<ResourceLocation, AttributesContainer> resolvedContainers = new HashMap<ResourceLocation, AttributesContainer>();
        for (Map.Entry entry : containers.entrySet()) {
            WeaponAttributes resolvedAttributes;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            AttributesContainer container = (AttributesContainer)entry.getValue();
            if (container.parent() != null && (resolvedAttributes = WeaponRegistry.resolveAttributes(id, container)) != null) {
                container = new AttributesContainer(null, resolvedAttributes);
            }
            resolvedContainers.put(id, container);
        }
        WeaponRegistry.containers = resolvedContainers;
    }

    public static WeaponAttributes resolveAttributes(ResourceLocation itemId, AttributesContainer container) {
        try {
            ArrayList<WeaponAttributes> resolutionChain = new ArrayList<WeaponAttributes>();
            AttributesContainer current = container;
            while (current != null) {
                resolutionChain.add(0, current.attributes());
                if (current.parent() != null) {
                    current = containers.get(ResourceLocation.parse((String)current.parent()));
                    continue;
                }
                current = null;
            }
            WeaponAttributes empty = WeaponAttributes.empty();
            WeaponAttributes resolvedAttributes = resolutionChain.stream().reduce(empty, (a, b) -> {
                if (b == null) {
                    return a;
                }
                return WeaponAttributesHelper.override(a, b);
            });
            WeaponAttributesHelper.validate(resolvedAttributes);
            return resolvedAttributes;
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve weapon attributes for: " + String.valueOf(itemId) + ". Reason: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void resolveAndRegisterAttributes(ResourceLocation itemId, AttributesContainer container) {
        WeaponAttributes resolvedAttributes = WeaponRegistry.resolveAttributes(itemId, container);
        if (resolvedAttributes != null) {
            WeaponRegistry.register(itemId, resolvedAttributes);
        }
    }

    public static void encodeRegistry() {
        boolean compressed = BetterCombatMod.config.weapon_registry_compression;
        ArrayList<String> chunks = new ArrayList<String>();
        SyncFormat syncContent = new SyncFormat();
        containers.forEach((key, value) -> syncContent.attributes.put(key.toString(), (AttributesContainer)value));
        registrations.forEach((key, value) -> syncContent.registrations.put(key.toString(), (WeaponAttributes)value));
        String json = gson.toJson((Object)syncContent);
        if (compressed) {
            json = CompressionHelper.gzipCompress(json);
        }
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute assignments loaded: " + json);
        }
        for (int i = 0; i < json.length(); i += 10000) {
            chunks.add(json.substring(i, Math.min(json.length(), i + 10000)));
        }
        encodedRegistrations = new Encoded(compressed, chunks);
        Packets.WeaponRegistrySync referencePacket = new Packets.WeaponRegistrySync(compressed, chunks);
        FriendlyByteBuf buffer = Platform.createByteBuffer();
        referencePacket.write(buffer);
        LOGGER.info("Encoded Weapon Attribute registry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of 10000)");
    }

    public static void decodeRegistry(Packets.WeaponRegistrySync syncPacket) {
        boolean compressed = syncPacket.compressed();
        String json = "";
        for (String chunk : syncPacket.chunks()) {
            json = json.concat(chunk);
        }
        if (compressed) {
            json = CompressionHelper.gzipDecompress(json);
        }
        LOGGER.info("Decoded Weapon Attribute registry in " + syncPacket.chunks().size() + " string chunks");
        if (BetterCombatMod.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry received: " + json);
        }
        SyncFormat sync = (SyncFormat)gson.fromJson(json, SyncFormat.class);
        containers.clear();
        sync.attributes.forEach((key, value) -> containers.put(ResourceLocation.parse((String)key), (AttributesContainer)value));
        registrations.clear();
        sync.registrations.forEach((key, value) -> registrations.put(ResourceLocation.parse((String)key), (WeaponAttributes)value));
    }

    public static Encoded getEncodedRegistry() {
        return encodedRegistrations;
    }

    public static class SyncFormat {
        public Map<String, AttributesContainer> attributes = new HashMap<String, AttributesContainer>();
        public Map<String, WeaponAttributes> registrations = new HashMap<String, WeaponAttributes>();
    }

    public record Encoded(boolean compressed, List<String> chunks) {
    }
}

