/*
 * Decompiled with CFR 0.152.
 */
package net.village_taverns;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.entity.schedule.ScheduleBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.village_taverns.block.TavernBlocks;
import org.jetbrains.annotations.Nullable;

public class TavernVillagers {
    public static final String BARTENDER = "bartender";
    public static final String ALWAYS_WORK = "always_work";
    public static final Schedule ALWAYS_WORK_SCHEDULE = new ScheduleBuilder(new Schedule()).changeActivityAt(50, Activity.WORK).changeActivityAt(23950, Activity.REST).build();
    public static final ResourceLocation PROFESSION_ID = ResourceLocation.fromNamespaceAndPath((String)"village_taverns", (String)"bartender");
    @Nullable
    public static VillagerProfession BAR_TENDER_PROFESSION;
    private static final int POTION_PRICE_T1 = 16;
    private static final int POTION_PRICE_T2 = 24;
    private static final int POTION_PRICE_T3 = 32;
    private static final int POTION_PRICE_T4 = 40;
    public static LinkedHashMap<Integer, List<VillagerTrades.ItemListing>> TRADES;
    public static String CRIT_MOD_ID;
    public static ResourceLocation CRIT_CHANCE_POTION_ID;
    public static ResourceLocation CRIT_DAMAGE_POTION_ID;

    public static VillagerProfession createProfession(String name, ResourceKey<PoiType> workStation) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"village_taverns", (String)name);
        return new VillagerProfession(id.toString(), entry -> entry.is(workStation), entry -> entry.is(workStation), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.BOTTLE_FILL);
    }

    public static void registerPOI() {
        ImmutableSet blockStates = ImmutableSet.copyOf((Collection)TavernBlocks.BARREL.block().getStateDefinition().getPossibleStates());
        PointOfInterestHelper.register((ResourceLocation)PROFESSION_ID, (int)1, (int)12, (Iterable)blockStates);
        Registry.register((Registry)BuiltInRegistries.SCHEDULE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"village_taverns", (String)ALWAYS_WORK), (Object)ALWAYS_WORK_SCHEDULE);
    }

    public static void registerVillagers() {
        VillagerProfession profession = TavernVillagers.createProfession(BARTENDER, (ResourceKey<PoiType>)ResourceKey.create((ResourceKey)BuiltInRegistries.POINT_OF_INTEREST_TYPE.key(), (ResourceLocation)PROFESSION_ID));
        Registry.register((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (ResourceLocation)PROFESSION_ID, (Object)profession);
        BAR_TENDER_PROFESSION = profession;
        TavernVillagers.setupTrades();
        for (Map.Entry<Integer, List<VillagerTrades.ItemListing>> entry : TRADES.entrySet()) {
            TradeOfferHelper.registerVillagerOffers((VillagerProfession)profession, (int)entry.getKey(), factories -> factories.addAll((Collection)entry.getValue()));
        }
    }

    public static void setupTrades() {
        ArrayList<VillagerTrades.ItemsForEmeralds> trades_level_1 = new ArrayList<VillagerTrades.ItemsForEmeralds>();
        trades_level_1.add(new VillagerTrades.ItemsForEmeralds(Items.COOKED_CHICKEN, 2, 1, 12, 10));
        trades_level_1.add(new VillagerTrades.ItemsForEmeralds(Items.COOKED_BEEF, 4, 1, 12, 10));
        trades_level_1.add(new VillagerTrades.ItemsForEmeralds(Items.BREAD, 4, 1, 12, 10));
        trades_level_1.add(new VillagerTrades.ItemsForEmeralds(Items.COOKED_RABBIT, 6, 1, 12, 10));
        TRADES.put(1, trades_level_1);
        ArrayList<VillagerTrades.ItemsForEmeralds> trades_level_2 = new ArrayList<VillagerTrades.ItemsForEmeralds>();
        trades_level_2.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.STRENGTH, 16, 1, 3, 20));
        trades_level_2.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.REGENERATION, 16, 1, 3, 20));
        trades_level_2.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.SWIFTNESS, 16, 1, 3, 20));
        trades_level_2.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.FIRE_RESISTANCE, 16, 1, 3, 20));
        TRADES.put(2, trades_level_2);
        ArrayList<VillagerTrades.ItemsForEmeralds> trades_level_3 = new ArrayList<VillagerTrades.ItemsForEmeralds>();
        TavernVillagers.addIfNotNull(trades_level_3, TavernVillagers.potionOffer("spell_power:spell_power.arcane", 24, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_3, TavernVillagers.potionOffer("spell_power:spell_power.fire", 24, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_3, TavernVillagers.potionOffer("spell_power:spell_power.frost", 24, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_3, TavernVillagers.potionOffer("spell_power:spell_power.healing", 24, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_3, TavernVillagers.potionOffer("ranged_weapon:ranged_weapon.damage", 24, 1, 3, 30));
        if (trades_level_3.isEmpty()) {
            trades_level_3.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.HARMING, 24, 1, 3, 30));
            trades_level_3.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.NIGHT_VISION, 24, 1, 3, 30));
            trades_level_3.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.WEAKNESS, 24, 1, 3, 30));
        }
        TRADES.put(3, trades_level_3);
        ArrayList<VillagerTrades.ItemsForEmeralds> trades_level_4 = new ArrayList<VillagerTrades.ItemsForEmeralds>();
        TavernVillagers.addIfNotNull(trades_level_4, TavernVillagers.potionOffer("spell_power:spell_power.critical_chance", 32, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_4, TavernVillagers.potionOffer("spell_power:spell_power.critical_damage", 32, 1, 3, 30));
        if (FabricLoader.getInstance().isModLoaded("critical_strike")) {
            TavernVillagers.addIfNotNull(trades_level_4, TavernVillagers.potionOffer(CRIT_CHANCE_POTION_ID.toString(), 32, 1, 3, 30));
            TavernVillagers.addIfNotNull(trades_level_4, TavernVillagers.potionOffer(CRIT_DAMAGE_POTION_ID.toString(), 32, 1, 3, 30));
        }
        if (trades_level_4.isEmpty()) {
            trades_level_4.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.LONG_REGENERATION, 32, 1, 3, 30));
            trades_level_4.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.LONG_LEAPING, 32, 1, 3, 30));
            trades_level_4.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.WATER_BREATHING, 32, 1, 3, 30));
        }
        TRADES.put(4, trades_level_4);
        ArrayList<VillagerTrades.ItemsForEmeralds> trades_level_5 = new ArrayList<VillagerTrades.ItemsForEmeralds>();
        TavernVillagers.addIfNotNull(trades_level_5, TavernVillagers.potionOffer("spell_power:spell_power.haste", 40, 1, 3, 30));
        TavernVillagers.addIfNotNull(trades_level_5, TavernVillagers.potionOffer("ranged_weapon:ranged_weapon.haste", 40, 1, 3, 30));
        trades_level_5.add(new VillagerTrades.ItemsForEmeralds(Items.OMINOUS_BOTTLE, 60, 1, 1, 40));
        trades_level_5.add(TavernVillagers.potionOffer((Holder<Potion>)Potions.LONG_FIRE_RESISTANCE, 40, 1, 3, 40));
        TRADES.put(5, trades_level_5);
    }

    private static <T> void addIfNotNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    private static VillagerTrades.ItemsForEmeralds potionOffer(String potionId, int price, int count, int maxUses, int experience) {
        ItemStack stack = TavernVillagers.createPotionStack(potionId);
        if (stack != null) {
            return new VillagerTrades.ItemsForEmeralds(stack, price, count, maxUses, experience);
        }
        return null;
    }

    private static VillagerTrades.ItemsForEmeralds potionOffer(Holder<Potion> potion, int price, int count, int maxUses, int experience) {
        ItemStack stack = TavernVillagers.createPotionStack(potion);
        return new VillagerTrades.ItemsForEmeralds(stack, price, count, maxUses, experience);
    }

    @Nullable
    private static ItemStack createPotionStack(String potionId) {
        ResourceLocation id = ResourceLocation.parse((String)potionId);
        Optional potion = BuiltInRegistries.POTION.getHolder(id);
        return potion.map(potionReference -> PotionContents.createItemStack((Item)Items.POTION, (Holder)potionReference)).orElse(null);
    }

    private static ItemStack createPotionStack(Holder<Potion> potion) {
        return PotionContents.createItemStack((Item)Items.POTION, potion);
    }

    static {
        TRADES = new LinkedHashMap();
        CRIT_MOD_ID = "critical_strike";
        CRIT_CHANCE_POTION_ID = ResourceLocation.fromNamespaceAndPath((String)CRIT_MOD_ID, (String)(CRIT_MOD_ID + "_chance"));
        CRIT_DAMAGE_POTION_ID = ResourceLocation.fromNamespaceAndPath((String)CRIT_MOD_ID, (String)(CRIT_MOD_ID + "_damage"));
    }
}

