/*
 * Decompiled with CFR 0.152.
 */
package net.village_taverns.block;

import java.util.ArrayList;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.village_taverns.block.BrewTapBlock;

public class TavernBlocks {
    public static final ArrayList<Entry> all = new ArrayList();
    public static final Entry BARREL = TavernBlocks.entry("barrel", new BrewTapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD).noOcclusion()));

    private static Entry entry(String name, Block block) {
        Item.Properties settings = new Item.Properties();
        BlockItem item = new BlockItem(block, settings);
        Entry entry = new Entry(name, block, item);
        all.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : all) {
            Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"village_taverns", (String)entry.name), (Object)entry.block);
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"village_taverns", (String)entry.name), (Object)entry.item());
        }
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS).register(content -> {
            for (Entry entry : all) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public record Entry(String name, Block block, BlockItem item) {
        public Entry(String name, Block block) {
            this(name, block, new BlockItem(block, new Item.Properties()));
        }
    }
}

