/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.inventory.IronChestMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IronChestScreen
extends AbstractContainerScreen<IronChestMenu>
implements MenuAccess<IronChestMenu> {
    private final IronChestsTypes chestType;
    private final int textureXSize;
    private final int textureYSize;

    public IronChestScreen(IronChestMenu ironChestMenu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)ironChestMenu, playerInventory, title);
        this.chestType = ironChestMenu.getChestType();
        this.imageWidth = ironChestMenu.getChestType().xSize;
        this.imageHeight = ironChestMenu.getChestType().ySize;
        this.textureXSize = ironChestMenu.getChestType().textureXSize;
        this.textureYSize = ironChestMenu.getChestType().textureYSize;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.chestType.guiTexture);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.chestType.guiTexture, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureXSize, this.textureYSize);
    }
}

