/*
 * Decompiled with CFR 0.152.
 */
package net.yablon.fishermans_haven.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.yablon.fishermans_haven.procedures.CheckIfWormsInSlotProcedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition1Procedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition2Procedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition3Procedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition4Procedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition5Procedure;
import net.yablon.fishermans_haven.procedures.FishTrapProgressCondition6Procedure;
import net.yablon.fishermans_haven.world.inventory.FishTrapGUIMenu;

public class FishTrapGUIScreen
extends AbstractContainerScreen<FishTrapGUIMenu> {
    private static final HashMap<String, Object> guistate = FishTrapGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"fishermans_haven:textures/screens/fish_trap_gui.png");

    public FishTrapGUIScreen(FishTrapGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 0;
        this.imageHeight = 0;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/fish_trap_gui_improved_new.png"), this.leftPos + -88, this.topPos + -103, 0.0f, 0.0f, 176, 186, 176, 186);
        if (CheckIfWormsInSlotProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/warning_message_box.png"), this.leftPos + -55, this.topPos + -114, 0.0f, 0.0f, 116, 17, 116, 17);
        }
        if (FishTrapProgressCondition1Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar1.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        if (FishTrapProgressCondition2Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar2.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        if (FishTrapProgressCondition3Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar3.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        if (FishTrapProgressCondition4Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar4.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        if (FishTrapProgressCondition5Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar5.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        if (FishTrapProgressCondition6Procedure.execute((LevelAccessor)this.world, this.x, this.y, this.z)) {
            guiGraphics.blit(ResourceLocation.parse((String)"fishermans_haven:textures/screens/progress_bar6.png"), this.leftPos + -1, this.topPos + -73, 0.0f, 0.0f, 20, 2, 20, 2);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (CheckIfWormsInSlotProcedure.execute((Entity)this.entity)) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.fishermans_haven.fish_trap_gui.label_worms_not_detected"), -37, -110, -1, false);
        }
    }

    public void init() {
        super.init();
    }
}

