/*
 * Decompiled with CFR 0.152.
 */
package net.yablon.fishermans_haven.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.yablon.fishermans_haven.entity.CrabEntityEntity;
import net.yablon.fishermans_haven.entity.GlowingLobsterEntityEntity;
import net.yablon.fishermans_haven.entity.LobsterEntityEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FishermansHavenModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"fishermans_haven");
    public static final DeferredHolder<EntityType<?>, EntityType<CrabEntityEntity>> CRAB = FishermansHavenModEntities.register("crab", EntityType.Builder.of(CrabEntityEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<LobsterEntityEntity>> LOBSTER_ENTITY = FishermansHavenModEntities.register("lobster_entity", EntityType.Builder.of(LobsterEntityEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.1f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<GlowingLobsterEntityEntity>> GLOWING_LOBSTER_ENTITY = FishermansHavenModEntities.register("glowing_lobster_entity", EntityType.Builder.of(GlowingLobsterEntityEntity::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        CrabEntityEntity.init(event);
        LobsterEntityEntity.init(event);
        GlowingLobsterEntityEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)CRAB.get(), CrabEntityEntity.createAttributes().build());
        event.put((EntityType)LOBSTER_ENTITY.get(), LobsterEntityEntity.createAttributes().build());
        event.put((EntityType)GLOWING_LOBSTER_ENTITY.get(), GlowingLobsterEntityEntity.createAttributes().build());
    }
}

