/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin.util;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.util.LegacyUtils;

public record AntiFarmingPerEntity(float limitPerEntity, int resetAfterSeconds) {
    public static Result<AntiFarmingPerEntity, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(LegacyUtils.wrapNoUnused(AntiFarmingPerEntity::parse, context));
    }

    private static Result<AntiFarmingPerEntity, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<Float> limitPerEntity = rootObject.getFloat("limit_per_entity").ifFailure(problems::add).getSuccess();
        Optional<Integer> resetAfterSeconds = rootObject.getInt("reset_after_seconds").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AntiFarmingPerEntity(limitPerEntity.orElseThrow().floatValue(), resetAfterSeconds.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    private static class Instance {
        private final Queue<TimeDamage> queue = new LinkedList<TimeDamage>();
        private float totalDamage = 0.0f;

        private Instance() {
        }

        public float addAndLimit(float damage, float limitPerEntity, long resetAfterSeconds) {
            if (this.totalDamage < limitPerEntity) {
                damage = Math.min(damage, limitPerEntity - this.totalDamage);
                this.queue.add(new TimeDamage(System.currentTimeMillis() + resetAfterSeconds * 1000L, damage));
                this.totalDamage += damage;
                return damage;
            }
            return 0.0f;
        }

        public boolean cleanupOutdated() {
            long currentTime = System.currentTimeMillis();
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                TimeDamage el = (TimeDamage)it.next();
                if (el.time >= currentTime) break;
                this.totalDamage -= el.damage;
                it.remove();
            }
            return this.queue.isEmpty();
        }

        private record TimeDamage(long time, float damage) {
        }
    }

    public static class Data {
        private final Reference2ObjectMap<AntiFarmingPerEntity, Instance> antiFarmingData = new Reference2ObjectOpenHashMap();

        public float addAndLimit(AntiFarmingPerEntity antiFarming, float damage) {
            return ((Instance)this.antiFarmingData.computeIfAbsent((Object)antiFarming, key -> new Instance())).addAndLimit(damage, antiFarming.limitPerEntity(), antiFarming.resetAfterSeconds());
        }

        public void removeOutdated() {
            this.antiFarmingData.values().removeIf(Instance::cleanupOutdated);
        }
    }
}

