/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.puffish.skillsmod.server.data.PlayerData;

public class ServerData
extends SavedData {
    private final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    private ServerData() {
    }

    private static ServerData read(CompoundTag tag, HolderLookup.Provider lookup) {
        ServerData playersData = new ServerData();
        CompoundTag playersNbt = tag.getCompound("players");
        playersNbt.getAllKeys().forEach(key -> playersData.players.put(UUID.fromString(key), PlayerData.read(playersNbt.getCompound(key))));
        return playersData;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookup) {
        CompoundTag playersNbt = new CompoundTag();
        for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
            playersNbt.put(entry.getKey().toString(), (Tag)entry.getValue().writeNbt(new CompoundTag()));
        }
        nbt.put("players", (Tag)playersNbt);
        return nbt;
    }

    public static SavedData.Factory<ServerData> getPersistentStateType() {
        return new SavedData.Factory(ServerData::new, ServerData::read, null);
    }

    public static ServerData getOrCreate(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.overworld().getDataStorage();
        return (ServerData)persistentStateManager.computeIfAbsent(ServerData.getPersistentStateType(), "puffish_skills");
    }

    public PlayerData getPlayerData(ServerPlayer player) {
        return this.players.computeIfAbsent(player.getUUID(), uuid -> PlayerData.empty());
    }

    public void putPlayerData(ServerPlayer player, PlayerData data) {
        this.players.put(player.getUUID(), data);
    }

    public boolean isDirty() {
        return true;
    }
}

