/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ConfigItemList {
    private final List<String> listedNamespaces = new ArrayList<String>();
    private final List<Item> listedItems = new ArrayList<Item>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        this.innerInitialize();
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    protected void innerInitialize() {
    }

    public boolean isListed(ItemStack stack) {
        String namespace;
        ResourceKey resourceKey;
        Item item = stack.getItem();
        if (this.listedItems.contains(item)) {
            return true;
        }
        return !this.listedNamespaces.isEmpty() && (resourceKey = (ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)item).orElse(null)) != null && this.listedNamespaces.contains(namespace = resourceKey.location().getNamespace());
    }

    public boolean registerNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        this.unregisterNamespace(namespace);
        this.listedNamespaces.add(namespace);
        this.logRegisterNamespace(namespace);
        return true;
    }

    protected void logRegisterNamespace(@NotNull String namespace) {
    }

    public boolean registerItem(@NotNull ItemStack item) {
        if (item.isEmpty()) {
            return false;
        }
        this.unregisterItem(item);
        this.listedItems.add(item.getItem());
        this.logRegisterItem(item);
        return true;
    }

    protected void logRegisterItem(@NotNull ItemStack item) {
    }

    public void register(List<String> entries) {
        entries.forEach(this::register);
    }

    public boolean register(String entry) {
        if (!this.initialized) {
            this.pendingRules.add(entry);
            return true;
        }
        String[] parts = entry.split("\\s*:\\s*");
        if (parts.length == 1) {
            return this.registerNamespace(parts[0]);
        }
        ResourceLocation resource = ResourceLocation.parse((String)entry);
        Item item = (Item)BuiltInRegistries.ITEM.get(resource);
        return this.registerItem(new ItemStack((ItemLike)item));
    }

    public boolean unregisterNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        return this.listedNamespaces.remove(namespace);
    }

    public boolean unregisterItem(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.listedItems.remove(stack.getItem());
    }
}

