/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PersonalKeyRecipe
extends CustomRecipe {
    public PersonalKeyRecipe(CraftingBookCategory cat) {
        super(cat);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        ItemStack pkey = this.findPersonalKey(craftingInput);
        return !pkey.isEmpty();
    }

    private ItemStack findPersonalKey(CraftingInput craftingInput) {
        ItemStack pkey = ItemStack.EMPTY;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemPersonalKey pitem;
            ItemStack item = craftingInput.getItem(i);
            if (item == ItemStack.EMPTY) continue;
            if (!pkey.isEmpty()) {
                return ItemStack.EMPTY;
            }
            Item item2 = item.getItem();
            if (item2 instanceof ItemPersonalKey && this.checkPersonalKey(pitem = (ItemPersonalKey)item2)) {
                pkey = item;
                continue;
            }
            return ItemStack.EMPTY;
        }
        return pkey;
    }

    private boolean checkPersonalKey(ItemPersonalKey item) {
        String provider = item.getSecurityProviderKey();
        if (provider == null) {
            provider = "default";
        }
        if (provider.equals("default")) {
            return true;
        }
        return provider.equals("ftb") && this.ftbEnabled();
    }

    private boolean ftbEnabled() {
        return ModSecurity.registry.getProvider("ftb") != null && (Boolean)ModCommonConfig.INSTANCE.INTEGRATION.ftbTeams.enableCycleRecipe.get() != false;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        int index;
        ItemStack pkey = this.findPersonalKey(inv);
        ArrayList<Item> cycle = new ArrayList<Item>();
        cycle.add((Item)ModItems.PERSONAL_KEY.get());
        if (this.ftbEnabled()) {
            cycle.add((Item)ModItems.PERSONAL_KEY_FTB.get());
        }
        if ((index = cycle.indexOf(pkey.getItem())) == -1) {
            return ItemStack.EMPTY;
        }
        if (++index >= cycle.size()) {
            index = 0;
        }
        return new ItemStack((ItemLike)cycle.get(index), 1);
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.PERSONAL_KEY_RECIPE_SERIALIZER.get();
    }
}

