/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.framing.FrameMaterial;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class CraftResultSlot
extends Slot {
    private final Container inputInventory;
    private final int[] inputSlots;
    private final Player player;
    private int amountCrafted;

    public CraftResultSlot(Player player, Container inputInventory, Container inventory, int[] inputSlots, int slot, int x, int y) {
        super(inventory, slot, x, y);
        this.player = player;
        this.inputSlots = inputSlots;
        this.inputInventory = inputInventory;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    @NotNull
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.amountCrafted += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    public void onTake(@NotNull Player player, @NotNull ItemStack stack) {
        for (int slot : this.inputSlots) {
            BlockItem blockItem;
            Block block;
            ItemStack itemTarget = this.inputInventory.getItem(slot);
            Item item = stack.getItem();
            if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof IFramedBlock) {
                IFramedBlock framedBlock = (IFramedBlock)block;
                if (slot == 1 && !framedBlock.supportsFrameMaterial(FrameMaterial.SIDE) || slot == 2 && !framedBlock.supportsFrameMaterial(FrameMaterial.TRIM) || slot == 3 && !framedBlock.supportsFrameMaterial(FrameMaterial.FRONT)) continue;
            }
            if (itemTarget.isEmpty()) continue;
            this.inputInventory.removeItem(slot, stack.getCount());
        }
        this.amountCrafted = 0;
    }

    protected void onQuickCraft(@NotNull ItemStack stack, int amount) {
        for (int slot : this.inputSlots) {
            ItemStack itemTarget = this.inputInventory.getItem(slot);
            if (itemTarget.isEmpty()) continue;
            this.inputInventory.removeItem(slot, amount);
        }
        this.amountCrafted += amount;
        super.onQuickCraft(stack, amount);
    }
}

