/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.sound;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public abstract class InstrumentSoundInstance<E extends Entity>
extends AbstractTickableSoundInstance {
    protected E entity;
    protected int sourceId;
    private final int ticksOffset;

    public InstrumentSoundInstance(E entity, int ticksOffset, SoundEvent soundEvent) {
        super(soundEvent, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.entity = entity;
        this.ticksOffset = ticksOffset;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.looping = true;
        this.delay = 0;
        this.volume = 2.0f;
        this.x = entity.getX();
        this.y = entity.getY();
        this.z = entity.getZ();
    }

    public void tick() {
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
    }

    public void stopSound() {
        super.stop();
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return super.canPlaySound();
    }

    public E getEntity() {
        return this.entity;
    }

    public int getTicksOffset() {
        return this.ticksOffset;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    public boolean isForSameEntity(InstrumentSoundInstance<E> other) {
        return this.entity.equals(other.entity);
    }
}

