/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.services;

import com.yungnickyoung.minecraft.ribbits.block.GiantLilyPadBlockNeoForge;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.item.RibbitSpawnEggItemNeoForge;
import com.yungnickyoung.minecraft.ribbits.module.EntityTypeModule;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicAllPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStartMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.RibbitStopMusicSinglePayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StartHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.network.payload.StopHearingMaracaPayload;
import com.yungnickyoung.minecraft.ribbits.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public void onRibbitStartMusicGoal(ServerLevel serverLevel, RibbitEntity newRibbit, RibbitEntity masterRibbit) {
        int tickOffset = newRibbit.equals((Object)masterRibbit) ? masterRibbit.getTicksPlayingMusic() : -1;
        RibbitStartMusicSinglePayload payload = new RibbitStartMusicSinglePayload(newRibbit.getUUID(), newRibbit.getRibbitData().getInstrument().getId(), tickOffset);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void onPlayerEnterBandRange(ServerPlayer player, ServerLevel serverLevel, RibbitEntity masterRibbit) {
        List ribbitsPlayingMusic = masterRibbit.getRibbitsPlayingMusic().stream().toList();
        ArrayList<UUID> ribbitIds = new ArrayList<UUID>();
        ribbitIds.add(masterRibbit.getUUID());
        ribbitIds.addAll(ribbitsPlayingMusic.stream().map(Entity::getUUID).toList());
        ArrayList<ResourceLocation> instrumentIds = new ArrayList<ResourceLocation>();
        instrumentIds.add(masterRibbit.getRibbitData().getInstrument().getId());
        instrumentIds.addAll(ribbitsPlayingMusic.stream().map(ribbit -> ribbit.getRibbitData().getInstrument().getId()).toList());
        RibbitStartMusicAllPayload payload = new RibbitStartMusicAllPayload(ribbitIds, instrumentIds, masterRibbit.getTicksPlayingMusic());
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void onPlayerExitBandRange(ServerPlayer player, ServerLevel serverLevel, RibbitEntity masterRibbit) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RibbitStopMusicSinglePayload(masterRibbit.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        for (RibbitEntity ribbit : masterRibbit.getRibbitsPlayingMusic()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RibbitStopMusicSinglePayload(ribbit.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void startHearingMaraca(ServerPlayer performer, ServerPlayer audienceMember) {
        PacketDistributor.sendToPlayer((ServerPlayer)audienceMember, (CustomPacketPayload)new StartHearingMaracaPayload(performer.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void stopHearingMaraca(ServerPlayer performer, ServerPlayer audienceMember) {
        PacketDistributor.sendToPlayer((ServerPlayer)audienceMember, (CustomPacketPayload)new StopHearingMaracaPayload(performer.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public Supplier<Block> getGiantLilyPadBlock() {
        return () -> new GiantLilyPadBlockNeoForge(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().sound(SoundType.LILY_PAD).noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    @Override
    public Supplier<Item> getRibbitSpawnEggItem(RibbitProfession profession, int backgroundColor, int highlightColor) {
        return () -> new RibbitSpawnEggItemNeoForge((EntityType<RibbitEntity>)((EntityType)EntityTypeModule.RIBBIT.get()), profession, backgroundColor, highlightColor, new Item.Properties());
    }

    @Override
    public void setBlockAsFlammable(Block block, int igniteChance, int burnChance) {
        FireBlock fireBlock = (FireBlock)Blocks.FIRE;
        fireBlock.setFlammable(block, igniteChance, burnChance);
    }
}

