/*
 * Decompiled with CFR 0.152.
 */
package com.ethan.createbb.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class TrayBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)1.0, (double)2.0, (double)16.0, (double)2.0, (double)3.0), (VoxelShape)Block.box((double)0.0, (double)1.0, (double)3.0, (double)1.0, (double)2.0, (double)13.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)2.0, (double)14.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)15.0, (double)1.0, (double)3.0, (double)16.0, (double)2.0, (double)13.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.5, (double)13.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape ROTATED_SHAPE = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.5, (double)15.0), (VoxelShape)Block.box((double)3.0, (double)1.0, (double)0.0, (double)13.0, (double)2.0, (double)1.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)3.0, (double)1.0, (double)15.0, (double)13.0, (double)2.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)13.0, (double)1.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)2.0, (double)1.0, (double)0.0, (double)3.0, (double)2.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public TrayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE : ROTATED_SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pState.getValue((Property)FACING) == Direction.NORTH || pState.getValue((Property)FACING) == Direction.SOUTH ? SHAPE : ROTATED_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState pState, LevelAccessor pLevel, BlockPos pPos, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public static class Blue
    extends TrayBlock {
        public Blue(BlockBehaviour.Properties pProperties) {
            super(pProperties);
        }
    }

    public static class Empty
    extends TrayBlock {
        public Empty(BlockBehaviour.Properties pProperties) {
            super(pProperties);
        }
    }

    public static class White
    extends TrayBlock {
        public White(BlockBehaviour.Properties pProperties) {
            super(pProperties);
        }
    }
}

