/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.advancements.criterion;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public class BuiltinTrigger
implements CriterionTrigger<BuiltinTrigger>,
CriterionTriggerInstance {
    private final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<BuiltinTrigger>>> listeners = new IdentityHashMap<PlayerAdvancements, Set<CriterionTrigger.Listener<BuiltinTrigger>>>();
    private final Codec<BuiltinTrigger> codec = Codec.unit((Object)this);

    public void trigger(ServerPlayer player) {
        PlayerAdvancements advancements = player.getAdvancements();
        if (this.listeners.containsKey(advancements)) {
            this.listeners.get(advancements).forEach(listener -> listener.run(advancements));
        }
    }

    public final void addPlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<BuiltinTrigger> listener) {
        this.listeners.computeIfAbsent(playerAdvancements, it -> Sets.newHashSet()).add(listener);
    }

    public final void removePlayerListener(PlayerAdvancements playerAdvancements, CriterionTrigger.Listener<BuiltinTrigger> listener) {
        Set<CriterionTrigger.Listener<BuiltinTrigger>> set = this.listeners.get(playerAdvancements);
        if (set != null) {
            set.remove(listener);
            if (set.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public final void removePlayerListeners(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Codec<BuiltinTrigger> codec() {
        return this.codec;
    }

    public void validate(CriterionValidator validator) {
    }
}

