/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public class RandomChanceCondition
extends StructureCondition {
    public static final MapCodec<RandomChanceCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("chance").forGetter(condition -> Float.valueOf(condition.chance))).apply((Applicative)builder, RandomChanceCondition::new));
    public final float chance;

    public RandomChanceCondition(float chance) {
        this.chance = chance;
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.RANDOM_CHANCE;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        RandomSource random = ctx.random();
        if (random == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'random' for random_chance condition!");
            return false;
        }
        return random.nextFloat() < this.chance;
    }
}

