/*
 * Decompiled with CFR 0.152.
 */
package net.arsenal.spell;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class AbsorptionStatusEffect
extends MobEffect {
    private final int healthPerStack;

    public AbsorptionStatusEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.healthPerStack = 2;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        return entity.getAbsorptionAmount() > 0.0f || entity.level().isClientSide;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        super.onEffectStarted(entity, amplifier);
        entity.setAbsorptionAmount(Math.max(entity.getAbsorptionAmount(), (float)(this.healthPerStack * (1 + amplifier))));
    }
}

