/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public interface ICurioRenderer {
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack var1, SlotContext var2, PoseStack var3, RenderLayerParent<T, M> var4, MultiBufferSource var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12);

    public static void translateIfSneaking(PoseStack matrixStack, LivingEntity livingEntity) {
        if (livingEntity.isCrouching()) {
            matrixStack.translate(0.0f, 0.1875f, 0.0f);
        }
    }

    public static void rotateIfSneaking(PoseStack matrixStack, LivingEntity livingEntity) {
        LivingEntityRenderer livingRenderer;
        EntityModel model;
        EntityRenderer render;
        if (livingEntity.isCrouching() && (render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)livingEntity)) instanceof LivingEntityRenderer && (model = (livingRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            matrixStack.mulPose(Axis.XP.rotation(((HumanoidModel)model).body.xRot));
        }
    }

    public static void followHeadRotations(LivingEntity livingEntity, ModelPart ... renderers) {
        LivingEntityRenderer livingRenderer;
        EntityModel model;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)livingEntity);
        if (render instanceof LivingEntityRenderer && (model = (livingRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            for (ModelPart renderer : renderers) {
                renderer.copyFrom(((HumanoidModel)model).head);
            }
        }
    }

    @SafeVarargs
    public static void followBodyRotations(LivingEntity livingEntity, HumanoidModel<LivingEntity> ... models) {
        LivingEntityRenderer livingRenderer;
        EntityModel entityModel;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)livingEntity);
        if (render instanceof LivingEntityRenderer && (entityModel = (livingRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            for (HumanoidModel<LivingEntity> model : models) {
                HumanoidModel bipedModel = (HumanoidModel)entityModel;
                bipedModel.copyPropertiesTo(model);
            }
        }
    }
}

