/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.v2.emissive.neoforge;

import com.blackgear.platform.client.v2.emissive.Emissiveness;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeEmissiveLayerBakedModel
implements BakedModel {
    private static final ConcurrentHashMap<BlockState, RenderType> DEFAULT_RENDER_TYPE_CACHE = new ConcurrentHashMap();
    private static final int EMISSIVE_BRIGHTNESS = 0xF000F0;
    private static final int VERTEX_SIZE = 8;
    private static final int VERTICES_PER_QUAD = 4;
    private static final int U_OFFSET = 4;
    private static final int V_OFFSET = 5;
    private static final int BRIGHTNESS_OFFSET = 6;
    private final BakedModel wrapped;

    public ForgeEmissiveLayerBakedModel(BakedModel wrapped) {
        this.wrapped = wrapped;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType renderType) {
        List originalQuads = this.wrapped.getQuads(state, side, random, data, renderType);
        if (originalQuads.isEmpty()) {
            return originalQuads;
        }
        List<BakedQuad> emissiveQuads = this.createEmissiveQuads(originalQuads, state, renderType);
        if (emissiveQuads.isEmpty()) {
            return originalQuads;
        }
        return ImmutableList.builder().addAll((Iterable)originalQuads).addAll(emissiveQuads).build();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        List originalQuads = this.wrapped.getQuads(state, direction, random);
        if (originalQuads.isEmpty() || state != null) {
            return originalQuads;
        }
        List<BakedQuad> emissiveQuads = this.createItemEmissiveQuads(originalQuads);
        if (emissiveQuads.isEmpty()) {
            return originalQuads;
        }
        return ImmutableList.builder().addAll((Iterable)originalQuads).addAll(emissiveQuads).build();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet originalTypes = this.wrapped.getRenderTypes(state, rand, data);
        if (!Emissiveness.hasEmissiveSprite(this.wrapped)) {
            return originalTypes;
        }
        HashSet<RenderType> renderTypes = new HashSet<RenderType>();
        originalTypes.forEach(renderTypes::add);
        if (originalTypes.contains(RenderType.solid())) {
            renderTypes.add(RenderType.cutoutMipped());
        }
        return ChunkRenderTypeSet.of(renderTypes);
    }

    public List<BakedModel> getRenderPasses(@NotNull ItemStack stack, boolean fabulous) {
        List originalPasses = this.wrapped.getRenderPasses(stack, fabulous);
        if (originalPasses.size() == 1 && originalPasses.get(0) == this.wrapped) {
            return Collections.singletonList(this);
        }
        ArrayList<BakedModel> result = new ArrayList<BakedModel>(originalPasses.size());
        for (BakedModel model : originalPasses) {
            if (model instanceof ForgeEmissiveLayerBakedModel || !Emissiveness.hasEmissiveSprite(model)) {
                result.add(model);
                continue;
            }
            result.add(new ForgeEmissiveLayerBakedModel(model));
        }
        return result;
    }

    @NotNull
    public List<RenderType> getRenderTypes(@NotNull ItemStack stack, boolean fabulous) {
        List originalTypes = this.wrapped.getRenderTypes(stack, fabulous);
        if (!Emissiveness.hasEmissiveSprite(this.wrapped)) {
            return originalTypes;
        }
        HashSet<RenderType> types = new HashSet<RenderType>(originalTypes);
        if (!(types.contains(RenderType.cutout()) || types.contains(RenderType.cutoutMipped()) || types.contains(RenderType.translucent()))) {
            types.add(RenderType.cutout());
        }
        return new ArrayList<RenderType>(types);
    }

    private List<BakedQuad> createEmissiveQuads(List<BakedQuad> originalQuads, @Nullable BlockState state, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> emissiveQuads = null;
        for (BakedQuad quad : originalQuads) {
            TextureAtlasSprite emissiveSprite = Emissiveness.INSTANCE.getEmissiveSprite(quad.getSprite());
            if (emissiveSprite == null) continue;
            RenderType emissiveRenderType = this.getEmissiveRenderType(state, renderType);
            if (renderType != null && renderType != emissiveRenderType) continue;
            if (emissiveQuads == null) {
                emissiveQuads = new ArrayList<BakedQuad>();
            }
            emissiveQuads.add(this.createEmissiveQuad(quad, emissiveSprite));
        }
        return emissiveQuads == null ? Collections.emptyList() : emissiveQuads;
    }

    private List<BakedQuad> createItemEmissiveQuads(List<BakedQuad> originalQuads) {
        ArrayList<BakedQuad> emissiveQuads = null;
        for (BakedQuad quad : originalQuads) {
            TextureAtlasSprite emissiveSprite = Emissiveness.INSTANCE.getEmissiveSprite(quad.getSprite());
            if (emissiveSprite == null) continue;
            if (emissiveQuads == null) {
                emissiveQuads = new ArrayList<BakedQuad>();
            }
            emissiveQuads.add(this.createEmissiveQuad(quad, emissiveSprite));
        }
        return emissiveQuads == null ? Collections.emptyList() : emissiveQuads;
    }

    private RenderType getEmissiveRenderType(@Nullable BlockState state, @Nullable RenderType origin) {
        if (origin == RenderType.solid()) {
            return RenderType.cutoutMipped();
        }
        if (origin == RenderType.cutout() || origin == RenderType.cutoutMipped() || origin == RenderType.translucent()) {
            return origin;
        }
        if (state != null) {
            RenderType defaultType = DEFAULT_RENDER_TYPE_CACHE.computeIfAbsent(state, ItemBlockRenderTypes::getChunkRenderType);
            return defaultType == RenderType.solid() ? RenderType.cutoutMipped() : RenderType.cutout();
        }
        return RenderType.cutout();
    }

    private BakedQuad createEmissiveQuad(BakedQuad originalQuad, TextureAtlasSprite emissiveSprite) {
        int[] emissiveVertices = this.interpolateUVAndBrightness(originalQuad.getVertices(), originalQuad.getSprite(), emissiveSprite);
        return new BakedQuad(emissiveVertices, originalQuad.getTintIndex(), originalQuad.getDirection(), emissiveSprite, originalQuad.isShade());
    }

    private int[] interpolateUVAndBrightness(int[] originalVertices, TextureAtlasSprite baseSprite, TextureAtlasSprite emissiveSprite) {
        int[] newVertices = (int[])originalVertices.clone();
        float baseU0 = baseSprite.getU0();
        float baseV0 = baseSprite.getV0();
        float baseURange = baseSprite.getU1() - baseU0;
        float baseVRange = baseSprite.getV1() - baseV0;
        float emissiveU0 = emissiveSprite.getU0();
        float emissiveV0 = emissiveSprite.getV0();
        float emissiveURange = emissiveSprite.getU1() - emissiveU0;
        float emissiveVRange = emissiveSprite.getV1() - emissiveV0;
        for (int vertex = 0; vertex < 4; ++vertex) {
            int vertexStart = vertex * 8;
            float originalU = Float.intBitsToFloat(newVertices[vertexStart + 4]);
            float originalV = Float.intBitsToFloat(newVertices[vertexStart + 5]);
            float normalizedU = baseURange > 0.0f ? (originalU - baseU0) / baseURange : 0.0f;
            float normalizedV = baseVRange > 0.0f ? (originalV - baseV0) / baseVRange : 0.0f;
            float emissiveU = emissiveU0 + normalizedU * emissiveURange;
            float emissiveV = emissiveV0 + normalizedV * emissiveVRange;
            newVertices[vertexStart + 4] = Float.floatToRawIntBits(emissiveU);
            newVertices[vertexStart + 5] = Float.floatToRawIntBits(emissiveV);
            newVertices[vertexStart + 6] = 0xF000F0;
        }
        return newVertices;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return this.wrapped.getModelData(level, pos, state, modelData);
    }

    public boolean useAmbientOcclusion() {
        return this.wrapped.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.wrapped.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.wrapped.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.wrapped.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.wrapped.getParticleIcon();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    public ItemOverrides getOverrides() {
        return this.wrapped.getOverrides();
    }

    public ItemTransforms getTransforms() {
        return this.wrapped.getTransforms();
    }
}

