/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.mixin.client.emissive;

import com.blackgear.platform.client.v2.emissive.EmissiveProperties;
import com.blackgear.platform.client.v2.emissive.SpriteResourceLoaderContext;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SpriteSourceList.class})
public abstract class SpriteResourceLoaderMixin {
    @Inject(method={"list(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/List;"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/ImmutableList;builder()Lcom/google/common/collect/ImmutableList$Builder;", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void platform$onReloadPost(ResourceManager resourceManager, CallbackInfoReturnable<List<Supplier<SpriteContents>>> cir, Map<ResourceLocation, SpriteSource.SpriteSupplier> contents) {
        SpriteResourceLoaderContext context = SpriteResourceLoaderContext.THREAD_LOCAL.get();
        if (context == null) {
            return;
        }
        String suffix = EmissiveProperties.getSuffix();
        if (suffix == null) {
            return;
        }
        Object2ObjectOpenHashMap emissiveContents = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap emissiveMappings = new Object2ObjectOpenHashMap();
        contents.entrySet().stream().filter(entry -> !((ResourceLocation)entry.getKey()).getPath().endsWith(suffix)).forEach(arg_0 -> SpriteResourceLoaderMixin.lambda$platform$onReloadPost$3(suffix, contents, (Map)emissiveMappings, resourceManager, (Map)emissiveContents, arg_0));
        contents.putAll((Map<ResourceLocation, SpriteSource.SpriteSupplier>)emissiveContents);
        if (!emissiveMappings.isEmpty()) {
            context.setEmissiveMappings((Map<ResourceLocation, ResourceLocation>)emissiveMappings);
        }
    }

    private static /* synthetic */ void lambda$platform$onReloadPost$3(String suffix, Map contents, Map emissiveMappings, ResourceManager resourceManager, Map emissiveContents, Map.Entry entry) {
        ResourceLocation id = (ResourceLocation)entry.getKey();
        ResourceLocation emissiveId = id.withPath(id.getPath() + suffix);
        if (contents.containsKey(emissiveId)) {
            emissiveMappings.put(id, emissiveId);
        } else {
            ResourceLocation emissive = emissiveId.withPath("textures/" + emissiveId.getPath() + ".png");
            resourceManager.getResource(emissive).ifPresent(resource -> {
                emissiveContents.put(emissiveId, supplier -> supplier.loadSprite(emissive, resource));
                emissiveMappings.put(id, emissiveId);
            });
        }
    }
}

