/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.config.EffectConfig;
import net.spell_engine.api.effect.CustomStatusEffect;
import net.spell_engine.api.effect.Effects;
import net.spell_engine.api.effect.RemoveOnHit;
import net.spell_engine.api.effect.Synchronized;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchools;
import net.wizards.effect.FrostShieldStatusEffect;
import net.wizards.effect.FrozenStatusEffect;

public class WizardsEffects {
    public static final List<Effects.Entry> entries = new ArrayList<Effects.Entry>();
    public static Effects.Entry frozen = WizardsEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frozen"), "Frozen", "Frozen in place", (MobEffect)new FrozenStatusEffect(MobEffectCategory.HARMFUL, 0x99CCFF).setVulnerability(SpellSchools.FROST, new SpellPower.Vulnerability(0.0f, 1.0f, 0.0f)), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -10.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE), new AttributeModifier(Attributes.JUMP_STRENGTH.getRegisteredName(), -10.0f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry frostShield = WizardsEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_shield"), "Frost Shield", "Protected by frost", (MobEffect)new FrostShieldStatusEffect(MobEffectCategory.BENEFICIAL, 0x99CCFF), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry frostSlowness = WizardsEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_slowness"), "Slowness", "Slowed by frost magic", (MobEffect)new FrozenStatusEffect(MobEffectCategory.HARMFUL, 0x99CCFF), new EffectConfig(List.of(new AttributeModifier(Attributes.MOVEMENT_SPEED.getRegisteredName(), -0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));
    public static Effects.Entry arcaneCharge = WizardsEffects.add(new Effects.Entry(ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_charge"), "Arcane Charge", "Empowered by arcane magic", (MobEffect)new CustomStatusEffect(MobEffectCategory.BENEFICIAL, 16731101), new EffectConfig(List.of(new AttributeModifier(SpellSchools.ARCANE.id.toString(), 0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))));

    private static Effects.Entry add(Effects.Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static void register(ConfigFile.Effects config) {
        RemoveOnHit.configure((MobEffect)WizardsEffects.frozen.effect, (RemoveOnHit.Trigger)RemoveOnHit.Trigger.DIRECT_HIT, (int)1, (float)1.0f);
        Synchronized.configure((MobEffect)WizardsEffects.frostSlowness.effect, (boolean)true);
        Synchronized.configure((MobEffect)WizardsEffects.frozen.effect, (boolean)true);
        Synchronized.configure((MobEffect)WizardsEffects.frostShield.effect, (boolean)true);
        Synchronized.configure((MobEffect)WizardsEffects.arcaneCharge.effect, (boolean)true);
        Effects.register(entries, (Map)config.effects);
    }
}

