/*
 * Decompiled with CFR 0.152.
 */
package net.runes;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.runes.api.RuneItems;
import net.runes.crafting.RuneCrafting;
import net.runes.crafting.RuneCraftingBlock;
import net.runes.crafting.RuneCraftingScreenHandler;
import net.runes.crafting.RunePouches;

public class RunesMod {
    public static final String ID = "runes";

    public static void init() {
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS).register(content -> content.accept((ItemLike)RuneCraftingBlock.ITEM));
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.COMBAT).register(content -> {
            for (RuneItems.Entry entry : RuneItems.entries) {
                content.accept((ItemLike)entry.item());
            }
        });
    }

    public static void registerSounds() {
        Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)RuneCrafting.ID, (Object)RuneCrafting.SOUND);
    }

    public static void registerScreenHandler() {
        Registry.register((Registry)BuiltInRegistries.MENU, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"crafting"), RuneCraftingScreenHandler.HANDLER_TYPE);
    }

    public static void registerRecipeType() {
        RuneCrafting.registerRecipe();
    }

    public static void registerBlocks() {
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"crafting_altar"), (Object)((Object)RuneCraftingBlock.INSTANCE));
    }

    public static void registerItems() {
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"crafting_altar"), (Object)RuneCraftingBlock.ITEM);
        for (RuneItems.Entry entry : RuneItems.entries) {
            Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)entry.id(), (Object)entry.item());
        }
        if (FabricLoader.getInstance().isModLoaded("bundleapi")) {
            RunePouches.register();
        }
    }
}

