/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm;

import com.google.common.collect.ImmutableSet;
import com.unlikepaladin.pfm.PaladinFurnitureModUpdateChecker;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.behavior.BathtubBehavior;
import com.unlikepaladin.pfm.blocks.behavior.SinkBehavior;
import com.unlikepaladin.pfm.compat.PFMModCompatibility;
import com.unlikepaladin.pfm.compat.cookingforblockheads.PFMCookingForBlockheads;
import com.unlikepaladin.pfm.compat.farmersdelight.PFMFarmersDelight;
import com.unlikepaladin.pfm.compat.imm_ptl.PFMImmersivePortals;
import com.unlikepaladin.pfm.config.PaladinFurnitureModConfig;
import com.unlikepaladin.pfm.data.materials.DynamicBlockRegistry;
import com.unlikepaladin.pfm.data.materials.StoneVariantRegistry;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.mixin.PFMPointOfInterestTypeAccessor;
import com.unlikepaladin.pfm.mixin.PFMPointOfInterestTypesAccessor;
import com.unlikepaladin.pfm.neoforge.PaladinFurnitureModImpl;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.dynamic.FurnitureEntry;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaladinFurnitureMod {
    public static final String MOD_ID = "pfm";
    public static final ResourceLocation FURNITURE_DYED_ID = ResourceLocation.parse((String)"pfm:furniture_dyed");
    public static final HashMap<Class<? extends Block>, FurnitureEntry<?>> furnitureEntryMap = new LinkedHashMap();
    public static SoundEvent FURNITURE_DYED_EVENT = SoundEvent.createVariableRangeEvent((ResourceLocation)FURNITURE_DYED_ID);
    public static final Logger GENERAL_LOGGER = LogManager.getLogger();
    public static Tuple<String, CreativeModeTab> FURNITURE_GROUP = new Tuple((Object)"furniture", null);
    public static Tuple<String, CreativeModeTab> DYE_KITS = new Tuple((Object)"dye_kits", null);
    private static PaladinFurnitureModUpdateChecker updateChecker;
    public static boolean isClient;
    public static List<PFMModCompatibility> pfmModCompatibilities;
    private static Boolean optifine;

    public void commonInit() {
        if (PFMFileUtil.isModLoaded("connectormod")) {
            GENERAL_LOGGER.error("Sinytra Connector has been detected, this mod can cause rendering and other issues. PFM is not responsible for any issues it may cause.");
        }
        SinkBehavior.registerBehavior();
        BathtubBehavior.registerBehavior();
        updateChecker = new PaladinFurnitureModUpdateChecker();
        updateChecker.checkForUpdates(PaladinFurnitureMod.getPFMConfig());
        DynamicBlockRegistry.addBlockSetContainer(WoodVariantRegistry.INSTANCE.getType(), WoodVariantRegistry.INSTANCE);
        DynamicBlockRegistry.addBlockSetContainer(StoneVariantRegistry.INSTANCE.getType(), StoneVariantRegistry.INSTANCE);
        if (PaladinFurnitureMod.getModList().contains("cookingforblockheads")) {
            pfmModCompatibilities.add(PFMCookingForBlockheads.getInstance());
        }
        if (PaladinFurnitureMod.getModList().contains("farmersdelight")) {
            pfmModCompatibilities.add(PFMFarmersDelight.getInstance());
        }
        if (PaladinFurnitureMod.getModList().contains("immersive_portals")) {
            pfmModCompatibilities.add(PFMImmersivePortals.getInstance());
        }
    }

    public static void replaceHomePOIStates() {
        PoiType homePOI = (PoiType)BuiltInRegistries.POINT_OF_INTEREST_TYPE.get(PoiTypes.HOME);
        Set<BlockState> originalBedStates = ((PFMPointOfInterestTypeAccessor)homePOI).getBlockStates();
        Set addedBedStates = (Set)Arrays.stream(PaladinFurnitureModBlocksItems.getBeds()).flatMap(block -> block.getStateDefinition().getPossibleStates().stream().filter(state -> state.getValue((Property)SimpleBedBlock.PART) == BedPart.HEAD)).collect(ImmutableSet.toImmutableSet());
        HashSet<BlockState> newBedStates = new HashSet<BlockState>();
        newBedStates.addAll(originalBedStates);
        newBedStates.addAll(addedBedStates);
        ((PFMPointOfInterestTypeAccessor)homePOI).setBlockStates((Set<BlockState>)ImmutableSet.copyOf(newBedStates));
        addedBedStates.forEach(state -> PFMPointOfInterestTypesAccessor.getBlockStateToPointOfInterestType().put((BlockState)state, (Holder<PoiType>)BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolderOrThrow(PoiTypes.HOME)));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PaladinFurnitureModConfig getPFMConfig() {
        return PaladinFurnitureModImpl.getPFMConfig();
    }

    public static PaladinFurnitureModUpdateChecker getUpdateChecker() {
        return updateChecker;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static List<String> getModList() {
        return PaladinFurnitureModImpl.getModList();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<String, String> getVersionMap() {
        return PaladinFurnitureModImpl.getVersionMap();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Loader getLoader() {
        return PaladinFurnitureModImpl.getLoader();
    }

    public static boolean isOptifineLoaded() {
        if (optifine == null) {
            try {
                Class.forName("net.optifine.shaders.Shaders");
                optifine = true;
                return true;
            }
            catch (ClassNotFoundException e) {
                optifine = false;
                return false;
            }
        }
        return optifine;
    }

    static {
        isClient = false;
        pfmModCompatibilities = new ArrayList<PFMModCompatibility>();
        optifine = null;
    }

    public static enum Loader implements StringRepresentable
    {
        FORGE("forge"),
        FABRIC_LIKE("fabric_like");

        final String name;

        private Loader(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

