/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractSittableBlock
extends HorizontalDirectionalBlock {
    private final BlockState baseBlockState = this.defaultBlockState();
    private final Block baseBlock = this.baseBlockState.getBlock();
    public static Map<Class<? extends Block>, MapCodec<AbstractSittableBlock>> CODECS = new HashMap<Class<? extends Block>, MapCodec<AbstractSittableBlock>>();
    public float height;

    public AbstractSittableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.height = 0.7f;
        if (!CODECS.containsKey((Object)this)) {
            CODECS.put(((Object)((Object)this)).getClass(), (MapCodec<AbstractSittableBlock>)AbstractSittableBlock.simpleCodec(settings1 -> this.getChairConstructor().apply((BlockBehaviour.Properties)settings1)));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.getHorizontalDirection() : ctx.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (player.isSpectator() || player.isShiftKeyDown()) {
            return InteractionResult.FAIL;
        }
        List active = world.getEntitiesOfClass(ChairEntity.class, new AABB(pos), Entity::isVehicle);
        if (active == null) {
            return InteractionResult.FAIL;
        }
        ArrayList hasPassenger = new ArrayList();
        active.forEach(chairEntity -> hasPassenger.add(chairEntity.getFirstPassenger()));
        if (!active.isEmpty() && hasPassenger.stream().anyMatch(Entity::isAlwaysTicking)) {
            return InteractionResult.FAIL;
        }
        if (!active.isEmpty()) {
            hasPassenger.forEach(Entity::stopRiding);
            return InteractionResult.SUCCESS;
        }
        if (this.sitEntity(world, pos, state, (Entity)player) == InteractionResult.SUCCESS) {
            if (!(state.getBlock() instanceof BasicToiletBlock)) {
                player.awardStat(Statistics.CHAIR_USED);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult sitEntity(Level world, BlockPos pos, BlockState state, Entity entityToSit) {
        double pz;
        double px;
        if (state.getBlock() instanceof BasicChairBlock) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            if (((Boolean)state.getValue((Property)BasicChairBlock.TUCKED)).booleanValue()) {
                switch (direction) {
                    case EAST: {
                        px = (double)pos.getX() + 0.1;
                        pz = (double)pos.getZ() + 0.5;
                        break;
                    }
                    case WEST: {
                        px = (double)pos.getX() + 0.9;
                        pz = (double)pos.getZ() + 0.5;
                        break;
                    }
                    case SOUTH: {
                        px = (double)pos.getX() + 0.5;
                        pz = (double)pos.getZ() + 0.1;
                        break;
                    }
                    default: {
                        px = (double)pos.getX() + 0.5;
                        pz = (double)pos.getZ() + 0.9;
                        break;
                    }
                }
            } else {
                px = (double)pos.getX() + 0.5;
                pz = (double)pos.getZ() + 0.5;
            }
        } else {
            px = (double)pos.getX() + 0.5;
            pz = (double)pos.getZ() + 0.5;
        }
        double py = (float)pos.getY() + this.height;
        float yaw = ((Direction)state.getValue((Property)FACING)).getOpposite().toYRot();
        ChairEntity chairEntity = (ChairEntity)Entities.CHAIR.create(world);
        chairEntity.moveTo(px, py, pz, yaw, 0.0f);
        chairEntity.setNoGravity(true);
        chairEntity.setSilent(true);
        chairEntity.setInvisible(false);
        chairEntity.setInvulnerable(true);
        chairEntity.setNoAi(true);
        chairEntity.setDiscardFriction(true);
        chairEntity.setYHeadRot(yaw);
        chairEntity.setYRot(yaw);
        chairEntity.setYBodyRot(yaw);
        if (world.addFreshEntity((Entity)chairEntity)) {
            entityToSit.startRiding((Entity)chairEntity, true);
            entityToSit.setYRot(yaw);
            entityToSit.setYHeadRot(yaw);
            chairEntity.setYRot(yaw);
            chairEntity.setYBodyRot(yaw);
            chairEntity.setYHeadRot(yaw);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        List active = world.getEntitiesOfClass(ChairEntity.class, new AABB(pos), Entity::isVehicle);
        if (active == null || !active.isEmpty()) {
            return;
        }
        if (entity instanceof Player || entity instanceof IronGolem || entity instanceof AbstractMinecart || entity.isPassenger() || !(entity instanceof LivingEntity) || entity instanceof ChairEntity) {
            return;
        }
        if (!PaladinFurnitureMod.getPFMConfig().doMobsSitOnChairs()) {
            return;
        }
        this.sitEntity(world, pos, state, entity);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public static boolean isWoodBased(BlockState state) {
        NoteBlockInstrument instrument = state.instrument();
        SoundType soundGroup = state.getSoundType();
        return soundGroup == SoundType.BAMBOO_WOOD || soundGroup == SoundType.WOOL || soundGroup == SoundType.CHERRY_WOOD || soundGroup == SoundType.WOOD || soundGroup == SoundType.NETHER_WOOD || instrument == NoteBlockInstrument.BASS;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODECS.get(((Object)((Object)this)).getClass());
    }

    public abstract Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor();
}

