/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.behavior.BathtubBehavior;
import com.unlikepaladin.pfm.blocks.blockentities.BathtubBlockEntity;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Entities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicBathtubBlock
extends BedBlock {
    public static final IntegerProperty LEVEL_8 = IntegerProperty.create((String)"level", (int)0, (int)8);
    private final Map<Item, BathtubBehavior> behaviorMap;
    private final Biome.Precipitation precipitation;
    private static final List<BasicBathtubBlock> basicBathtubBlocks = new ArrayList<BasicBathtubBlock>();
    public float height;
    private static final VoxelShape FOOT = Shapes.join((VoxelShape)BasicBathtubBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), (VoxelShape)BasicBathtubBlock.box((double)0.0, (double)2.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape FOOT_NORTH = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.NORTH, FOOT);
    private static final VoxelShape FOOT_EAST = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.EAST, FOOT);
    private static final VoxelShape FOOT_SOUTH = SimpleStoolBlock.rotateShape(Direction.WEST, Direction.SOUTH, FOOT);
    public static final MapCodec<BasicBathtubBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BasicBathtubBlock.propertiesCodec(), (App)BathtubBehavior.CODEC.fieldOf("behaviorMap").forGetter(basicBathtubBlock -> basicBathtubBlock.behaviorMap), (App)Biome.Precipitation.CODEC.fieldOf("precipitation").forGetter(basicBathtubBlock -> basicBathtubBlock.precipitation)).apply((Applicative)instance, BasicBathtubBlock::new));

    public BasicBathtubBlock(BlockBehaviour.Properties settings, Map<Item, BathtubBehavior> map, Biome.Precipitation precipitation) {
        super(DyeColor.WHITE, settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)LEVEL_8, (Comparable)Integer.valueOf(0))).setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        this.behaviorMap = map;
        this.precipitation = precipitation;
        this.height = 0.05f;
        basicBathtubBlocks.add(this);
    }

    public static Stream<BasicBathtubBlock> basicBathtubBlockStream() {
        return basicBathtubBlocks.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{LEVEL_8});
        super.createBlockStateDefinition(stateManager);
    }

    protected void onFireCollision(BlockState state, Level world, BlockPos pos) {
        BasicBathtubBlock.decrementFluidLevel(state, world, pos);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (state.getValue((Property)PART) == BedPart.HEAD) {
            direction = direction.getOpposite();
        }
        return world.getBlockState(pos.relative(direction)).isAir() || world.getBlockState(pos.relative(direction)).getBlock() == this;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide) {
            world.setBlock(pos.relative((Direction)state.getValue((Property)FACING)), (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue((Property)PART, (Comparable)BedPart.HEAD), 3);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.isClientSide && player.isCreative() && (bedPart = (BedPart)state.getValue((Property)PART)) == BedPart.FOOT && (blockState = world.getBlockState(blockPos = pos.relative(BasicBathtubBlock.getDirectionTowardsOtherPart(bedPart, (Direction)state.getValue((Property)FACING))))).getBlock() == this && blockState.getValue((Property)PART) == BedPart.HEAD) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        int i = (Integer)state.getValue((Property)LEVEL_8);
        if (!world.isClientSide && entity.isOnFire() && i != 0) {
            entity.clearFire();
            this.onFireCollision(state, world, pos);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)LEVEL_8);
    }

    protected static boolean canFillWithPrecipitation(Level world, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return world.getRandom().nextFloat() < 0.05f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return world.getRandom().nextFloat() < 0.1f;
        }
        return false;
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (!BasicBathtubBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.getValue((Property)LEVEL_8) == 8 || this.precipitation != precipitation) {
            return;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LEVEL_8));
    }

    public static void decrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.getValue((Property)LEVEL_8) - 1;
        if (i < 0) {
            i = 0;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL_8, (Comparable)Integer.valueOf(i)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.getHorizontalDirection() : ctx.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState sourceState;
        BlockPos sourcePos = pos.below().below();
        ItemStack itemStack = player.getItemInHand(hand);
        BathtubBehavior sinkBehavior = this.behaviorMap.get(itemStack.getItem());
        if (sinkBehavior != null && itemStack.getItem() != Items.AIR) {
            return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
        }
        if ((Integer)state.getValue((Property)LEVEL_8) > 0 && player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
            world.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
            return ItemInteractionResult.SUCCESS;
        }
        if ((Integer)state.getValue((Property)LEVEL_8) < 8 && (sourceState = world.getBlockState(sourcePos)).getFluidState().getType() == Fluids.WATER && !sourceState.getFluidState().isEmpty()) {
            BathtubBlockEntity blockEntity;
            if (sourceState.getProperties().contains(BlockStateProperties.WATERLOGGED)) {
                world.setBlockAndUpdate(sourcePos, (BlockState)sourceState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else {
                world.setBlockAndUpdate(sourcePos, Blocks.AIR.defaultBlockState());
            }
            BlockPos headPos = pos;
            if (state.getValue((Property)PART) != BedPart.HEAD) {
                headPos = headPos.relative(BasicBathtubBlock.getDirectionTowardsOtherPart((BedPart)state.getValue((Property)PART), (Direction)state.getValue((Property)FACING)));
            }
            if ((blockEntity = (BathtubBlockEntity)world.getBlockEntity(headPos)) != null) {
                blockEntity.setFilling(true);
            }
            BathtubBehavior.fillTub(world, pos, player, hand, player.getItemInHand(hand), state, SoundEvents.WATER_AMBIENT, false);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isNight() && world.dimensionType().bedWorks()) {
            super.useWithoutItem(state, world, pos, player, hit);
            return InteractionResult.SUCCESS;
        }
        return this.sit(state, world, pos, player, hit);
    }

    public InteractionResult sit(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (player.isSpectator() || player.isShiftKeyDown()) {
                return InteractionResult.PASS;
            }
            double px = (double)pos.getX() + 0.5;
            double pz = (double)pos.getZ() + 0.5;
            double py = (float)pos.getY() + this.height;
            List active = world.getEntitiesOfClass(ChairEntity.class, new AABB(pos), Entity::hasExactlyOnePlayerPassenger);
            if (!active.isEmpty()) {
                return InteractionResult.PASS;
            }
            float yaw = ((Direction)state.getValue((Property)FACING)).getOpposite().toYRot();
            if (state.getValue((Property)PART) == BedPart.FOOT) {
                yaw = ((Direction)state.getValue((Property)FACING)).toYRot();
            }
            ChairEntity entity = (ChairEntity)Entities.CHAIR.create(world);
            entity.moveTo(px, py, pz, yaw, 0.0f);
            entity.setNoGravity(true);
            entity.setSilent(true);
            entity.setInvisible(false);
            entity.setInvulnerable(true);
            entity.setNoAi(true);
            entity.setYHeadRot(yaw);
            entity.setYBodyRot(yaw);
            if (world.addFreshEntity((Entity)entity)) {
                player.startRiding((Entity)entity, true);
                player.setYHeadRot(yaw);
                entity.setYBodyRot(yaw);
                entity.setYHeadRot(yaw);
                player.awardStat(Statistics.USE_BATHTUB);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BedPart tubPart = (BedPart)state.getValue((Property)PART);
        if (direction == BasicBathtubBlock.getDirectionTowardsOtherPart(tubPart, (Direction)state.getValue((Property)FACING))) {
            if (neighborState.is((Block)this) && neighborState.getValue((Property)PART) != tubPart) {
                return (BlockState)((BlockState)state.setValue((Property)LEVEL_8, (Comparable)((Integer)neighborState.getValue((Property)LEVEL_8)))).setValue((Property)OCCUPIED, (Comparable)((Boolean)neighborState.getValue((Property)OCCUPIED)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction getDirectionTowardsOtherPart(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BedPart part = (BedPart)state.getValue((Property)PART);
        if (part == BedPart.FOOT) {
            switch (facing) {
                case WEST: {
                    return FOOT;
                }
                case EAST: {
                    return FOOT_EAST;
                }
                case NORTH: {
                    return FOOT_NORTH;
                }
            }
            return FOOT_SOUTH;
        }
        switch (facing) {
            case WEST: {
                return FOOT_EAST;
            }
            case EAST: {
                return FOOT;
            }
            case NORTH: {
                return FOOT_SOUTH;
            }
        }
        return FOOT_NORTH;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.BATHTUB_BLOCK_ENTITY, BathtubBlockEntity::tick);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BathtubBlockEntity(pos, state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public static void spawnParticles(Direction facing, Level world, BlockPos pos) {
        if (world.isClientSide) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (facing == Direction.EAST) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.76, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.5, (double)y + 0.8, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, (double)x + 0.24, (double)y + 0.8, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public MapCodec<BedBlock> codec() {
        return CODEC;
    }
}

