/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicCoffeeTableBlock
extends Block {
    private final Block baseBlock;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_BASIC_TABLES_COFFEE = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_TABLES_COFFEE = new ArrayList<FurnitureBlock>();
    static final VoxelShape TABLE_BASIC_BASE = BasicCoffeeTableBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_LEG = BasicCoffeeTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_LEG = BasicCoffeeTableBlock.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_LEG = BasicCoffeeTableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_LEG = BasicCoffeeTableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_EAST_WEST_NORTH = BasicCoffeeTableBlock.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_EAST_WEST_SOUTH = BasicCoffeeTableBlock.box((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_TOP = BasicCoffeeTableBlock.box((double)4.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_BOTTOM = BasicCoffeeTableBlock.box((double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_BOTTOM = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_TOP = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)2.0, (double)12.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH_WEST = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_NORTH_SOUTH_EAST = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_EAST_CORNER = BasicCoffeeTableBlock.box((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_EAST_CORNER = BasicCoffeeTableBlock.box((double)14.0, (double)0.0, (double)12.0, (double)16.0, (double)2.0, (double)14.0);
    static final VoxelShape TABLE_BASIC_NORTH_WEST_CORNER = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)4.0);
    static final VoxelShape TABLE_BASIC_SOUTH_WEST_CORNER = BasicCoffeeTableBlock.box((double)0.0, (double)0.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public BasicCoffeeTableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.baseBlockState) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicCoffeeTableBlock.class)) {
            WOOD_BASIC_TABLES_COFFEE.add(new FurnitureBlock(this, "coffee_table_basic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicCoffeeTableBlock.class)) {
            STONE_BASIC_TABLES_COFFEE.add(new FurnitureBlock(this, "coffee_table_basic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodBasicTables() {
        return WOOD_BASIC_TABLES_COFFEE.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicTables() {
        return STONE_BASIC_TABLES_COFFEE.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{AXIS});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction.Axis facing = ctx.getHorizontalDirection().getAxis();
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)facing);
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.getBlock() instanceof BasicCoffeeTableBlock : blockState.getBlock() == this;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public boolean canConnect(BlockGetter world, BlockState state, BlockPos neighborPos, BlockPos pos) {
        BlockState neighborState = world.getBlockState(neighborPos);
        if (neighborState.hasProperty(AXIS)) {
            return neighborState.getValue(AXIS) == state.getValue(AXIS) && this.canConnect(neighborState);
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction.Axis dir = (Direction.Axis)state.getValue(AXIS);
        Boolean north = this.canConnect(world, state, pos.north(), pos);
        boolean east = this.canConnect(world, state, pos.east(), pos);
        boolean west = this.canConnect(world, state, pos.west(), pos);
        boolean south = this.canConnect(world, state, pos.south(), pos);
        boolean cornerNorthWest = north != false && west && !this.canConnect(world, state, pos.north().west(), pos);
        boolean cornerNorthEast = north != false && east && !this.canConnect(world, state, pos.north().east(), pos);
        boolean cornerSouthEast = south && east && !this.canConnect(world, state, pos.south().east(), pos);
        boolean cornerSouthWest = south && west && !this.canConnect(world, state, pos.south().west(), pos);
        String key = north.toString() + east + west + south + cornerNorthWest + cornerNorthEast + cornerSouthEast + cornerSouthWest + dir.getSerializedName();
        if (!VOXEL_SHAPES.containsKey(key)) {
            BasicCoffeeTableBlock.generateVoxelShape(key, north, east, west, south, cornerNorthWest, cornerNorthEast, cornerSouthEast, cornerSouthWest, dir);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south, Boolean cornerNorthWest, Boolean cornerNorthEast, Boolean cornerSouthEast, Boolean cornerSouthWest, Direction.Axis axis) {
        VoxelShape newVoxelShape = TABLE_BASIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_BASIC_EAST_WEST_NORTH, TABLE_BASIC_EAST_WEST_SOUTH});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, TABLE_BASIC_NORTH_EAST_LEG, TABLE_BASIC_NORTH_WEST_LEG));
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, TABLE_BASIC_NORTH_WEST_LEG, TABLE_BASIC_SOUTH_WEST_LEG));
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, TABLE_BASIC_SOUTH_EAST_LEG, TABLE_BASIC_NORTH_EAST_LEG));
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, TABLE_BASIC_SOUTH_WEST_LEG, TABLE_BASIC_SOUTH_EAST_LEG));
        }
        if (cornerNorthEast.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, Shapes.or((VoxelShape)TABLE_BASIC_NORTH_EAST_LEG, (VoxelShape)TABLE_BASIC_NORTH_EAST_CORNER), Shapes.or((VoxelShape)TABLE_BASIC_NORTH_WEST_LEG, (VoxelShape)TABLE_BASIC_NORTH_WEST_CORNER)));
        }
        if (cornerNorthWest.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, Shapes.or((VoxelShape)TABLE_BASIC_NORTH_WEST_LEG, (VoxelShape)TABLE_BASIC_NORTH_WEST_CORNER), Shapes.or((VoxelShape)TABLE_BASIC_SOUTH_WEST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_WEST_CORNER)));
        }
        if (cornerSouthWest.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, Shapes.or((VoxelShape)TABLE_BASIC_SOUTH_WEST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_WEST_CORNER), Shapes.or((VoxelShape)TABLE_BASIC_SOUTH_EAST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_EAST_CORNER)));
        }
        if (cornerSouthEast.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicCoffeeTableBlock.getShapeForAxis(axis, Shapes.or((VoxelShape)TABLE_BASIC_SOUTH_EAST_LEG, (VoxelShape)TABLE_BASIC_SOUTH_EAST_CORNER), Shapes.or((VoxelShape)TABLE_BASIC_NORTH_EAST_LEG, (VoxelShape)TABLE_BASIC_NORTH_EAST_CORNER)));
        }
        if (axis == Direction.Axis.Z) {
            if (!north.booleanValue() && south.booleanValue() && !east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_NORTH);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_SOUTH);
            }
            if (!north.booleanValue() && east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_TOP);
            }
            if (!south.booleanValue() && !east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_BOTTOM);
            }
            if (!south.booleanValue() && east.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_BOTTOM);
            }
            if (!north.booleanValue() && !east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (!north.booleanValue() && east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_WEST);
            }
            if (!south.booleanValue() && east.booleanValue() && west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_EAST);
            }
        } else {
            if (!north.booleanValue() && south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_BOTTOM);
            }
            if (north.booleanValue() && !south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_BOTTOM);
            }
            if (!north.booleanValue() && south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_EAST_TOP);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (north.booleanValue() && !south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_SOUTH_WEST_TOP);
            }
            if (!(north.booleanValue() || south.booleanValue() || east.booleanValue())) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_NORTH);
            }
            if (!(north.booleanValue() || south.booleanValue() || west.booleanValue())) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_EAST_WEST_SOUTH);
            }
            if (north.booleanValue() && south.booleanValue() && !east.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_WEST);
            }
            if (north.booleanValue() && south.booleanValue() && !west.booleanValue()) {
                newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_BASIC_NORTH_SOUTH_EAST);
            }
            newVoxelShape = BasicCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.EAST, newVoxelShape);
        }
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    private static VoxelShape getShapeForAxis(Direction.Axis axis, VoxelShape a, VoxelShape b) {
        if (axis == Direction.Axis.Z) {
            return a;
        }
        if (axis == Direction.Axis.X) {
            return b;
        }
        return Shapes.empty();
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation(Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)((Direction.Axis)state.getValue(AXIS)))));
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

