/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity3x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicDeskCabinetBlock
extends HorizontalFacingBlockWithEntity {
    private final Block baseBlock;
    public static BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final List<FurnitureBlock> WOOD_BASIC_DESK_CABINETS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_DESK_CABINETS = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    protected FurnitureBlock deskCabinetBlock;
    public static final MapCodec<BasicDeskCabinetBlock> CODEC = BasicDeskCabinetBlock.simpleCodec(BasicDeskCabinetBlock::new);
    static final VoxelShape TABLE_CLASSIC_BASE = BasicDeskCabinetBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_EAST_LEG = BasicDeskCabinetBlock.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_WEST_LEG = BasicDeskCabinetBlock.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_WEST_LEG = BasicDeskCabinetBlock.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)14.0, (double)15.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_EAST_LEG = BasicDeskCabinetBlock.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)14.0, (double)15.0);
    static final VoxelShape DESK_SINGLE_CLOSED = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)3.0, (double)9.0, (double)2.0, (double)13.0, (double)13.0, (double)3.0), BasicDeskCabinetBlock.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)6.5, (double)5.5, (double)1.0, (double)9.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)6.5, (double)10.5, (double)1.0, (double)9.5, (double)11.5, (double)2.0)});
    static final VoxelShape DESK_SINGLE_OPEN = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)3.0, (double)9.0, (double)2.0, (double)13.0, (double)13.0, (double)3.0), BasicDeskCabinetBlock.box((double)3.0, (double)4.0, (double)-2.0, (double)13.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)6.5, (double)5.5, (double)-3.0, (double)9.5, (double)6.5, (double)-2.0), BasicDeskCabinetBlock.box((double)6.5, (double)10.5, (double)1.0, (double)9.5, (double)11.5, (double)2.0)});
    static final VoxelShape DESK_RIGHT_CLOSED = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)1.0, (double)9.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)1.0, (double)4.0, (double)2.0, (double)11.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)4.5, (double)5.5, (double)1.0, (double)7.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)4.5, (double)10.5, (double)1.0, (double)7.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)0.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)});
    static final VoxelShape DESK_RIGHT_OPEN = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)1.0, (double)9.0, (double)2.0, (double)11.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)4.5, (double)10.5, (double)1.0, (double)7.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)0.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), BasicDeskCabinetBlock.box((double)1.0, (double)4.0, (double)-2.0, (double)11.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)4.5, (double)5.5, (double)-3.0, (double)7.5, (double)6.5, (double)-2.0)});
    static final VoxelShape DESK_LEFT_CLOSED = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)5.0, (double)9.0, (double)2.0, (double)15.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)5.0, (double)4.0, (double)2.0, (double)15.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)8.5, (double)5.5, (double)1.0, (double)11.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)8.5, (double)10.5, (double)1.0, (double)11.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0)});
    static final VoxelShape DESK_LEFT_OPEN = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)5.0, (double)9.0, (double)2.0, (double)15.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)8.5, (double)10.5, (double)1.0, (double)11.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0), BasicDeskCabinetBlock.box((double)5.0, (double)4.0, (double)-2.0, (double)15.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)8.5, (double)5.5, (double)-3.0, (double)11.5, (double)6.5, (double)-2.0)});
    static final VoxelShape DESK_MIDDLE_CLOSED = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)9.0, (double)2.0, (double)13.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)3.0, (double)4.0, (double)2.0, (double)13.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)6.5, (double)5.5, (double)1.0, (double)9.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)6.5, (double)10.5, (double)1.0, (double)9.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0)});
    static final VoxelShape DESK_MIDDLE_OPEN = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)9.0, (double)2.0, (double)13.0, (double)13.0, (double)3.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)6.5, (double)10.5, (double)1.0, (double)9.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)0.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0), BasicDeskCabinetBlock.box((double)3.0, (double)4.0, (double)-2.0, (double)13.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)6.5, (double)5.5, (double)-3.0, (double)9.5, (double)6.5, (double)-2.0)});
    static final VoxelShape DESK_OUTER_CORNER_CLOSED = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)13.0, (double)13.0, (double)14.0, (double)16.0), BasicDeskCabinetBlock.box((double)4.0, (double)9.0, (double)2.0, (double)14.0, (double)13.0, (double)3.0), BasicDeskCabinetBlock.box((double)4.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)7.5, (double)5.5, (double)1.0, (double)10.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)7.5, (double)10.5, (double)1.0, (double)10.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)2.0, (double)9.0, (double)4.0, (double)3.0, (double)13.0, (double)14.0), BasicDeskCabinetBlock.box((double)2.0, (double)4.0, (double)4.0, (double)3.0, (double)8.0, (double)14.0), BasicDeskCabinetBlock.box((double)1.0, (double)5.5, (double)7.5, (double)2.0, (double)6.5, (double)10.5), BasicDeskCabinetBlock.box((double)1.0, (double)10.5, (double)7.5, (double)2.0, (double)11.5, (double)10.5)});
    static final VoxelShape DESK_OUTER_CORNER_OPEN = Shapes.or((VoxelShape)BasicDeskCabinetBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicDeskCabinetBlock.box((double)-2.0, (double)4.0, (double)4.0, (double)3.0, (double)8.0, (double)14.0), BasicDeskCabinetBlock.box((double)-3.0, (double)5.5, (double)7.5, (double)-2.0, (double)6.5, (double)10.5), BasicDeskCabinetBlock.box((double)13.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0, (double)13.0), BasicDeskCabinetBlock.box((double)4.0, (double)9.0, (double)2.0, (double)14.0, (double)13.0, (double)3.0), BasicDeskCabinetBlock.box((double)4.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)3.0), BasicDeskCabinetBlock.box((double)7.5, (double)5.5, (double)1.0, (double)10.5, (double)6.5, (double)2.0), BasicDeskCabinetBlock.box((double)7.5, (double)10.5, (double)1.0, (double)10.5, (double)11.5, (double)2.0), BasicDeskCabinetBlock.box((double)2.0, (double)9.0, (double)4.0, (double)3.0, (double)13.0, (double)14.0), BasicDeskCabinetBlock.box((double)1.0, (double)10.5, (double)7.5, (double)2.0, (double)11.5, (double)10.5)});
    static final VoxelShape DESK_INSIDE_CORNER = BasicDeskCabinetBlock.box((double)0.0, (double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)13.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public BasicDeskCabinetBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        this.deskCabinetBlock = new FurnitureBlock((Block)this, "desk_cabinet_basic");
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicDeskCabinetBlock.class)) {
            WOOD_BASIC_DESK_CABINETS.add(this.deskCabinetBlock);
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicDeskCabinetBlock.class)) {
            STONE_BASIC_DESK_CABINETS.add(this.deskCabinetBlock);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodBasicDeskCabinets() {
        return WOOD_BASIC_DESK_CABINETS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicDeskCabinets() {
        return STONE_BASIC_DESK_CABINETS.stream();
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{OPEN});
        super.createBlockStateDefinition(stateManager);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean canConnect(BlockState blockState) {
        if (blockState.getBlock() instanceof BasicDeskCabinetBlock && !PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect()) {
            return this.deskCabinetBlock.getBaseMaterial() == ((BasicDeskCabinetBlock)blockState.getBlock()).deskCabinetBlock.getBaseMaterial();
        }
        if (blockState.getBlock() instanceof BasicDeskCabinetBlock) {
            return true;
        }
        if (blockState.getBlock() instanceof BasicDeskBlock && !PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect()) {
            return this.deskCabinetBlock.getBaseMaterial() == ((BasicDeskBlock)blockState.getBlock()).deskBlock.getBaseMaterial();
        }
        return blockState.getBlock() instanceof BasicDeskBlock;
    }

    public boolean isDifferentOrientation(BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos.relative(dir));
        return !this.canConnect(blockState);
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String corner;
        Boolean north = this.canConnect(world.getBlockState(pos.north()));
        boolean east = this.canConnect(world.getBlockState(pos.east()));
        boolean west = this.canConnect(world.getBlockState(pos.west()));
        boolean south = this.canConnect(world.getBlockState(pos.south()));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        Direction isFacing = (Direction)state.getValue((Property)FACING);
        BlockState rightState = world.getBlockState(pos.relative(isFacing.getCounterClockWise()));
        boolean right = this.canConnect(rightState) && rightState.getBlock() instanceof BasicDeskCabinetBlock;
        BlockState leftState = world.getBlockState(pos.relative(isFacing.getClockWise()));
        boolean left = this.canConnect(leftState) && leftState.getBlock() instanceof BasicDeskCabinetBlock;
        BlockState neighborStateFacing = world.getBlockState(pos.relative(isFacing));
        BlockState neighborStateOpposite = world.getBlockState(pos.relative(isFacing.getOpposite()));
        boolean rotatedCorner = false;
        if (this.canConnect(neighborStateFacing) && neighborStateFacing.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            neighborFacing = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (neighborFacing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(world, pos, neighborFacing.getOpposite())) {
                corner = "inner";
                if (neighborFacing != isFacing.getCounterClockWise()) {
                    rotatedCorner = true;
                }
            } else {
                corner = "none";
            }
        } else if (this.canConnect(neighborStateOpposite) && neighborStateOpposite.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            neighborFacing = (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (neighborFacing.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(world, pos, neighborFacing)) {
                corner = "outer";
                if (neighborFacing != isFacing.getCounterClockWise()) {
                    rotatedCorner = true;
                }
            } else {
                corner = "none";
            }
        } else {
            corner = "none";
        }
        String key = north.toString() + east + west + south + left + right + corner + rotatedCorner + open + isFacing.getSerializedName();
        if (!VOXEL_SHAPES.containsKey(key)) {
            BasicDeskCabinetBlock.generateVoxelShape(key, north, east, west, south, left, right, corner, rotatedCorner, open, isFacing);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south, boolean left, boolean right, String corner, boolean rotatedCorner, boolean open, Direction facing) {
        VoxelShape newVoxelShape = TABLE_CLASSIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_CLASSIC_NORTH_EAST_LEG, TABLE_CLASSIC_SOUTH_WEST_LEG, TABLE_CLASSIC_SOUTH_EAST_LEG, TABLE_CLASSIC_NORTH_WEST_LEG});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_EAST_LEG);
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_WEST_LEG);
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_EAST_LEG);
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_WEST_LEG);
        }
        newVoxelShape = corner == "none" ? Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.NORTH, facing, BasicDeskCabinetBlock.middleDeskShape(left, right, open))) : (corner == "outer" ? (!rotatedCorner ? (open ? Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.NORTH, facing, DESK_OUTER_CORNER_OPEN)) : Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.NORTH, facing, DESK_OUTER_CORNER_CLOSED))) : (open ? Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.WEST, facing, DESK_OUTER_CORNER_OPEN)) : Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.WEST, facing, DESK_OUTER_CORNER_CLOSED)))) : (!rotatedCorner ? Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.NORTH, facing, DESK_INSIDE_CORNER)) : Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)BasicDeskCabinetBlock.rotateShape(Direction.WEST, facing, DESK_INSIDE_CORNER))));
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    private static VoxelShape middleDeskShape(boolean left, boolean right, boolean open) {
        if (left && right) {
            if (open) {
                return DESK_MIDDLE_OPEN;
            }
            return DESK_MIDDLE_CLOSED;
        }
        if (left) {
            if (open) {
                return DESK_LEFT_OPEN;
            }
            return DESK_LEFT_CLOSED;
        }
        if (right) {
            if (open) {
                return DESK_RIGHT_OPEN;
            }
            return DESK_RIGHT_CLOSED;
        }
        if (open) {
            return DESK_SINGLE_OPEN;
        }
        return DESK_SINGLE_CLOSED;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity3x3.getFactory().create(pos, state);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GenericStorageBlockEntity3x3) {
            player.openMenu((MenuProvider)((GenericStorageBlockEntity3x3)blockEntity));
            player.awardStat(Statistics.DRAWER_SEARCHED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }
}

