/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.blockentities.ShowerHandleBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicShowerHandleBlock
extends HorizontalFacingBlockWithEntity {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final List<BasicShowerHandleBlock> SHOWER_HANDLE_BLOCKS = new ArrayList<BasicShowerHandleBlock>();
    public static final MapCodec<BasicShowerHandleBlock> CODEC = BasicShowerHandleBlock.simpleCodec(BasicShowerHandleBlock::new);
    private static final VoxelShape SHOWER_HANDLE = Shapes.or((VoxelShape)BasicShowerHandleBlock.box((double)11.5, (double)8.0, (double)14.0, (double)12.5, (double)9.0, (double)15.0), (VoxelShape[])new VoxelShape[]{BasicShowerHandleBlock.box((double)11.0, (double)7.5, (double)15.0, (double)13.0, (double)9.5, (double)16.0), BasicShowerHandleBlock.box((double)11.5, (double)6.5, (double)13.0, (double)12.5, (double)10.5, (double)14.0), BasicShowerHandleBlock.box((double)10.0, (double)8.0, (double)13.0, (double)14.0, (double)9.0, (double)14.0), BasicShowerHandleBlock.box((double)3.5, (double)8.0, (double)14.0, (double)4.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.box((double)3.0, (double)7.5, (double)15.0, (double)5.0, (double)9.5, (double)16.0), BasicShowerHandleBlock.box((double)3.5, (double)6.5, (double)13.0, (double)4.5, (double)10.5, (double)14.0), BasicShowerHandleBlock.box((double)2.0, (double)8.0, (double)13.0, (double)6.0, (double)9.0, (double)14.0)});
    private static final VoxelShape SHOWER_HANDLE_SOUTH = BasicTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_EAST = BasicTableBlock.rotateShape(Direction.NORTH, Direction.EAST, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_WEST = BasicTableBlock.rotateShape(Direction.NORTH, Direction.WEST, SHOWER_HANDLE);
    private static final VoxelShape SHOWER_HANDLE_OPEN = Shapes.or((VoxelShape)BasicShowerHandleBlock.box((double)11.0, (double)7.5, (double)15.0, (double)13.0, (double)9.5, (double)16.0), (VoxelShape[])new VoxelShape[]{BasicShowerHandleBlock.box((double)11.5, (double)8.0, (double)13.0, (double)12.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.box((double)12.5, (double)9.0, (double)13.0, (double)13.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.box((double)12.5, (double)7.0, (double)13.0, (double)13.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.box((double)10.5, (double)9.0, (double)13.0, (double)11.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.box((double)10.5, (double)7.0, (double)13.0, (double)11.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.box((double)3.5, (double)8.0, (double)13.0, (double)4.5, (double)9.0, (double)15.0), BasicShowerHandleBlock.box((double)4.5, (double)9.0, (double)13.0, (double)5.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.box((double)4.5, (double)7.0, (double)13.0, (double)5.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.box((double)2.5, (double)9.0, (double)13.0, (double)3.5, (double)10.0, (double)14.0), BasicShowerHandleBlock.box((double)2.5, (double)7.0, (double)13.0, (double)3.5, (double)8.0, (double)14.0), BasicShowerHandleBlock.box((double)3.0, (double)7.5, (double)15.0, (double)5.0, (double)9.5, (double)16.0)});
    private static final VoxelShape SHOWER_HANDLE_SOUTH_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, SHOWER_HANDLE_OPEN);
    private static final VoxelShape SHOWER_HANDLE_EAST_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.EAST, SHOWER_HANDLE_OPEN);
    private static final VoxelShape SHOWER_HANDLE_WEST_OPEN = BasicTableBlock.rotateShape(Direction.NORTH, Direction.WEST, SHOWER_HANDLE_OPEN);

    public BasicShowerHandleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        SHOWER_HANDLE_BLOCKS.add(this);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static Stream<BasicShowerHandleBlock> streamShowerHandleBlocks() {
        return SHOWER_HANDLE_BLOCKS.stream();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState blockState = this.toggleOpen(state, world, pos, false, false);
        float f = (Boolean)blockState.getValue((Property)POWERED) != false ? 0.9f : 0.8f;
        world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
        world.gameEvent((Entity)player, (Holder)((Boolean)blockState.getValue((Property)POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        return InteractionResult.CONSUME;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (itemStack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CustomData nbtCompound = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (nbtCompound.contains("showerHead") && blockEntity instanceof ShowerHandleBlockEntity) {
                itemStack.remove(DataComponents.BLOCK_ENTITY_DATA);
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
    }

    public BlockState toggleOpen(BlockState state, Level world, BlockPos pos, boolean listenTo, boolean toggleTo) {
        state = listenTo ? (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(toggleTo)) : (BlockState)state.cycle((Property)POWERED);
        world.setBlock(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        if (world.getBlockEntity(pos) instanceof ShowerHandleBlockEntity) {
            ((ShowerHandleBlockEntity)world.getBlockEntity(pos)).setState((Boolean)state.getValue((Property)POWERED));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = BasicShowerHandleBlock.getDirection(state);
        boolean open = (Boolean)state.getValue((Property)POWERED);
        switch (facing) {
            case SOUTH: {
                if (open) {
                    return SHOWER_HANDLE_SOUTH_OPEN;
                }
                return SHOWER_HANDLE_SOUTH;
            }
            case EAST: {
                if (open) {
                    return SHOWER_HANDLE_EAST_OPEN;
                }
                return SHOWER_HANDLE_EAST;
            }
            case WEST: {
                if (open) {
                    return SHOWER_HANDLE_WEST_OPEN;
                }
                return SHOWER_HANDLE_WEST;
            }
        }
        if (open) {
            return SHOWER_HANDLE_OPEN;
        }
        return SHOWER_HANDLE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private void updateNeighbors(BlockState state, Level world, BlockPos pos) {
        world.updateNeighborsAt(pos, (Block)this);
        world.updateNeighborsAt(pos.relative(BasicShowerHandleBlock.getDirection(state).getOpposite()), (Block)this);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (world.getBlockEntity(pos) != null) {
            ((ShowerHandleBlockEntity)world.getBlockEntity(pos)).setState(false);
        }
        this.spawnDestroyParticles(world, player, pos, state);
        if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
        }
        world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShowerHandleBlockEntity(pos, state);
    }

    protected static Direction getDirection(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }
}

