/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.util.Function3;
import com.unlikepaladin.pfm.blocks.AbstractSinkBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicSinkBlock
extends AbstractSinkBlock {
    private static final List<BasicSinkBlock> SINKS = new ArrayList<BasicSinkBlock>();
    public static final VoxelShape NORTH = Shapes.or((VoxelShape)BasicSinkBlock.box((double)4.0, (double)1.0, (double)0.3, (double)12.0, (double)11.3, (double)8.3), (VoxelShape[])new VoxelShape[]{BasicSinkBlock.box((double)3.0, (double)0.0, (double)0.3, (double)13.0, (double)1.0, (double)9.3), BasicSinkBlock.box((double)1.0625, (double)11.3, (double)0.3, (double)14.9675, (double)16.3, (double)12.3)});
    public static final VoxelShape SOUTH = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NORTH);
    public static final VoxelShape EAST = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, NORTH);
    public static final VoxelShape WEST = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.WEST, NORTH);

    public BasicSinkBlock(BlockBehaviour.Properties settings, Biome.Precipitation precipitation, CauldronInteraction.InteractionMap behaviorMap) {
        super(settings, precipitation, behaviorMap);
        SINKS.add(this);
    }

    @Override
    public Function3<BlockBehaviour.Properties, Biome.Precipitation, CauldronInteraction.InteractionMap, AbstractSinkBlock> getSinkConstructor() {
        return BasicSinkBlock::new;
    }

    public static Stream<BasicSinkBlock> streamSinks() {
        return SINKS.stream();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (facing) {
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return SOUTH;
    }
}

