/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicCoffeeTableBlock
extends Block {
    private final Block baseBlock;
    private static final List<FurnitureBlock> WOOD_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CLASSIC_TABLES = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    static final VoxelShape TABLE_CLASSIC_BASE = ClassicCoffeeTableBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_EAST_LEG = ClassicCoffeeTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0);
    static final VoxelShape TABLE_CLASSIC_NORTH_WEST_LEG = ClassicCoffeeTableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_WEST_LEG = ClassicCoffeeTableBlock.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0);
    static final VoxelShape TABLE_CLASSIC_SOUTH_EAST_LEG = ClassicCoffeeTableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0);
    static final Map<String, VoxelShape> VOXEL_SHAPES = new HashMap<String, VoxelShape>();

    public ClassicCoffeeTableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)this.getStateDefinition().any());
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.baseBlockState) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicCoffeeTableBlock.class)) {
            WOOD_CLASSIC_TABLES.add(new FurnitureBlock(this, "coffee_table_classic"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicCoffeeTableBlock.class)) {
            STONE_CLASSIC_TABLES.add(new FurnitureBlock(this, "coffee_table_classic"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodClassicTables() {
        return WOOD_CLASSIC_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicTables() {
        return STONE_CLASSIC_TABLES.stream();
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.defaultBlockState();
    }

    public boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.getBlock() instanceof ClassicCoffeeTableBlock : blockState.getBlock() == this;
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Boolean north = this.canConnect(world.getBlockState(pos.north()));
        boolean east = this.canConnect(world.getBlockState(pos.east()));
        boolean west = this.canConnect(world.getBlockState(pos.west()));
        boolean south = this.canConnect(world.getBlockState(pos.south()));
        String key = north.toString() + east + west + south;
        if (!VOXEL_SHAPES.containsKey(key)) {
            ClassicCoffeeTableBlock.generateVoxelShape(key, north, east, west, south);
        }
        return VOXEL_SHAPES.get(key);
    }

    private static void generateVoxelShape(String key, Boolean north, Boolean east, Boolean west, Boolean south) {
        VoxelShape newVoxelShape = TABLE_CLASSIC_BASE;
        if (!(north.booleanValue() || south.booleanValue() || east.booleanValue() || west.booleanValue())) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape[])new VoxelShape[]{TABLE_CLASSIC_NORTH_EAST_LEG, TABLE_CLASSIC_SOUTH_WEST_LEG, TABLE_CLASSIC_SOUTH_EAST_LEG, TABLE_CLASSIC_NORTH_WEST_LEG});
        }
        if (!north.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_EAST_LEG);
        }
        if (!north.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_NORTH_WEST_LEG);
        }
        if (!south.booleanValue() && !east.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_EAST_LEG);
        }
        if (!south.booleanValue() && !west.booleanValue()) {
            newVoxelShape = Shapes.or((VoxelShape)newVoxelShape, (VoxelShape)TABLE_CLASSIC_SOUTH_WEST_LEG);
        }
        VOXEL_SHAPES.put(key, newVoxelShape);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

