/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.MiddleShape;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity9x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ClassicNightstandBlock
extends HorizontalFacingBlockWithEntity {
    public static BooleanProperty OPEN = BlockStateProperties.OPEN;
    private static final List<FurnitureBlock> WOOD_NIGHTSTAND = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_NIGHTSTAND = new ArrayList<FurnitureBlock>();
    public static final MapCodec<ClassicNightstandBlock> CODEC = ClassicNightstandBlock.simpleCodec(ClassicNightstandBlock::new);
    static final VoxelShape NIGHT_STAND = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)3.0, (double)1.0, (double)1.0, (double)13.0, (double)3.0, (double)2.0), ClassicNightstandBlock.box((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)14.0, (double)15.0), ClassicNightstandBlock.box((double)0.5, (double)0.0, (double)0.0, (double)3.5, (double)1.0, (double)16.0), ClassicNightstandBlock.box((double)12.5, (double)0.0, (double)0.0, (double)15.5, (double)1.0, (double)16.0), ClassicNightstandBlock.box((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0), ClassicNightstandBlock.box((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)8.0, (double)2.0), ClassicNightstandBlock.box((double)6.5, (double)5.5, (double)0.0, (double)9.5, (double)6.5, (double)1.0), ClassicNightstandBlock.box((double)6.5, (double)10.5, (double)0.0, (double)9.5, (double)11.5, (double)1.0)});
    static final VoxelShape NIGHT_STAND_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND);
    static final VoxelShape NIGHT_STAND_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND);
    static final VoxelShape NIGHT_STAND_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND);
    static final VoxelShape NIGHT_STAND_OPEN = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)3.0, (double)1.0, (double)1.0, (double)13.0, (double)3.0, (double)2.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)1.0, (double)3.0, (double)14.0, (double)2.0), ClassicNightstandBlock.box((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)2.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)14.0, (double)15.0), ClassicNightstandBlock.box((double)0.5, (double)0.0, (double)0.0, (double)3.5, (double)1.0, (double)16.0), ClassicNightstandBlock.box((double)12.5, (double)0.0, (double)0.0, (double)15.5, (double)1.0, (double)16.0), ClassicNightstandBlock.box((double)4.0, (double)9.0, (double)1.0, (double)12.0, (double)13.0, (double)2.0), ClassicNightstandBlock.box((double)4.0, (double)4.0, (double)-6.0, (double)12.0, (double)8.0, (double)2.0), ClassicNightstandBlock.box((double)6.5, (double)10.5, (double)0.0, (double)9.5, (double)11.5, (double)1.0), ClassicNightstandBlock.box((double)6.5, (double)5.5, (double)-7.0, (double)9.5, (double)6.5, (double)-6.0)});
    static final VoxelShape NIGHT_STAND_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_OPEN);
    static final VoxelShape NIGHT_STAND_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_OPEN);
    static final VoxelShape NIGHT_STAND_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_OPEN);
    static final VoxelShape NIGHT_STAND_MIDDLE = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)2.5, (double)2.0, (double)13.0, (double)13.5), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)6.5, (double)1.0, (double)11.5, (double)9.5), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)6.5, (double)1.0, (double)11.5, (double)9.5)});
    static final VoxelShape NIGHT_STAND_MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_MIDDLE);
    static final VoxelShape NIGHT_STAND_MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_MIDDLE);
    static final VoxelShape NIGHT_STAND_MIDDLE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_MIDDLE);
    static final VoxelShape NIGHT_STAND_MIDDLE_OPEN = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)16.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)2.5, (double)2.0, (double)13.0, (double)13.5), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)6.5, (double)1.0, (double)11.5, (double)9.5), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)6.5, (double)1.0, (double)11.5, (double)9.5)});
    static final VoxelShape NIGHT_STAND_MIDDLE_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_MIDDLE_OPEN);
    static final VoxelShape NIGHT_STAND_MIDDLE_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_MIDDLE_OPEN);
    static final VoxelShape NIGHT_STAND_MIDDLE_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_MIDDLE_OPEN);
    static final VoxelShape NIGHT_STAND_LEFT = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)2.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)16.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)14.0, (double)3.0), ClassicNightstandBlock.box((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)1.0, (double)3.5), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)4.0, (double)2.0, (double)13.0, (double)15.0), ClassicNightstandBlock.box((double)1.0, (double)4.0, (double)4.0, (double)2.0, (double)8.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)5.5, (double)8.0, (double)1.0, (double)6.5, (double)11.0), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)8.0, (double)1.0, (double)11.5, (double)11.0)});
    static final VoxelShape NIGHT_STAND_LEFT_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_LEFT);
    static final VoxelShape NIGHT_STAND_LEFT_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_LEFT);
    static final VoxelShape NIGHT_STAND_LEFT_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_LEFT);
    static final VoxelShape NIGHT_STAND_LEFT_OPEN = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)16.0), ClassicNightstandBlock.box((double)-7.0, (double)5.5, (double)8.0, (double)-6.0, (double)6.5, (double)11.0), ClassicNightstandBlock.box((double)-6.0, (double)4.0, (double)4.0, (double)2.0, (double)8.0, (double)15.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)14.0, (double)3.0), ClassicNightstandBlock.box((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)1.0, (double)3.5), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)4.0, (double)2.0, (double)13.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)8.0, (double)1.0, (double)11.5, (double)11.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)});
    static final VoxelShape NIGHT_STAND_LEFT_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_LEFT_OPEN);
    static final VoxelShape NIGHT_STAND_LEFT_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_LEFT_OPEN);
    static final VoxelShape NIGHT_STAND_LEFT_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_LEFT_OPEN);
    static final VoxelShape NIGHT_STAND_RIGHT = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)13.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)0.0, (double)12.5, (double)16.0, (double)1.0, (double)15.5), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)1.0, (double)2.0, (double)13.0, (double)12.0), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)5.0, (double)1.0, (double)11.5, (double)8.0), ClassicNightstandBlock.box((double)0.0, (double)5.5, (double)5.0, (double)1.0, (double)6.5, (double)8.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), ClassicNightstandBlock.box((double)1.0, (double)4.0, (double)1.0, (double)2.0, (double)8.0, (double)12.0)});
    static final VoxelShape NIGHT_STAND_RIGHT_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_RIGHT);
    static final VoxelShape NIGHT_STAND_RIGHT_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_RIGHT);
    static final VoxelShape NIGHT_STAND_RIGHT_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_RIGHT);
    static final VoxelShape NIGHT_STAND_RIGHT_OPEN = Shapes.or((VoxelShape)ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)15.0), (VoxelShape[])new VoxelShape[]{ClassicNightstandBlock.box((double)15.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)0.0, (double)2.0, (double)3.0, (double)13.0), ClassicNightstandBlock.box((double)1.0, (double)1.0, (double)13.0, (double)2.0, (double)14.0, (double)15.0), ClassicNightstandBlock.box((double)0.0, (double)0.0, (double)12.5, (double)16.0, (double)1.0, (double)15.5), ClassicNightstandBlock.box((double)1.0, (double)9.0, (double)1.0, (double)2.0, (double)13.0, (double)12.0), ClassicNightstandBlock.box((double)0.0, (double)10.5, (double)5.0, (double)1.0, (double)11.5, (double)8.0), ClassicNightstandBlock.box((double)-7.0, (double)5.5, (double)5.0, (double)-6.0, (double)6.5, (double)8.0), ClassicNightstandBlock.box((double)2.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), ClassicNightstandBlock.box((double)-6.0, (double)4.0, (double)1.0, (double)2.0, (double)8.0, (double)12.0)});
    static final VoxelShape NIGHT_STAND_RIGHT_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, NIGHT_STAND_RIGHT_OPEN);
    static final VoxelShape NIGHT_STAND_RIGHT_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, NIGHT_STAND_RIGHT_OPEN);
    static final VoxelShape NIGHT_STAND_RIGHT_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, NIGHT_STAND_RIGHT_OPEN);

    public ClassicNightstandBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicNightstandBlock.class)) {
            WOOD_NIGHTSTAND.add(new FurnitureBlock((Block)this, "classic_nightstand"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicNightstandBlock.class)) {
            STONE_NIGHTSTAND.add(new FurnitureBlock((Block)this, "classic_nightstand"));
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodClassicNightstands() {
        return WOOD_NIGHTSTAND.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicNightstands() {
        return STONE_NIGHTSTAND.stream();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{OPEN});
        super.createBlockStateDefinition(stateManager);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GenericStorageBlockEntity9x3) {
            player.openMenu((MenuProvider)((GenericStorageBlockEntity9x3)blockEntity));
            player.awardStat(Statistics.CABINET_SEARCHED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity9x3.getFactory().create(pos, state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public boolean isStand(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.getBlockState(pos.relative(direction));
        if (state.getBlock() == this) {
            Direction sourceDirection = (Direction)state.getValue((Property)FACING);
            return sourceDirection.equals((Object)tableDirection);
        }
        return false;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean left = this.isStand(world, pos, dir.getCounterClockWise(), dir);
        boolean right = this.isStand(world, pos, dir.getClockWise(), dir);
        MiddleShape shape = left || right ? (left && right ? MiddleShape.MIDDLE : (left ? MiddleShape.LEFT : MiddleShape.RIGHT)) : MiddleShape.SINGLE;
        switch (shape) {
            case SINGLE: {
                switch (dir) {
                    case NORTH: {
                        if (open) {
                            return NIGHT_STAND_OPEN;
                        }
                        return NIGHT_STAND;
                    }
                    case SOUTH: {
                        if (open) {
                            return NIGHT_STAND_OPEN_SOUTH;
                        }
                        return NIGHT_STAND_SOUTH;
                    }
                    case EAST: {
                        if (open) {
                            return NIGHT_STAND_OPEN_EAST;
                        }
                        return NIGHT_STAND_EAST;
                    }
                }
                if (open) {
                    return NIGHT_STAND_OPEN_WEST;
                }
                return NIGHT_STAND_WEST;
            }
            case MIDDLE: {
                switch (dir) {
                    case NORTH: {
                        if (open) {
                            return NIGHT_STAND_MIDDLE_OPEN_EAST;
                        }
                        return NIGHT_STAND_MIDDLE_EAST;
                    }
                    case SOUTH: {
                        if (open) {
                            return NIGHT_STAND_MIDDLE_OPEN_WEST;
                        }
                        return NIGHT_STAND_MIDDLE_WEST;
                    }
                    case EAST: {
                        if (open) {
                            return NIGHT_STAND_MIDDLE_OPEN_SOUTH;
                        }
                        return NIGHT_STAND_MIDDLE_SOUTH;
                    }
                }
                if (open) {
                    return NIGHT_STAND_MIDDLE_OPEN;
                }
                return NIGHT_STAND_MIDDLE;
            }
            case LEFT: {
                switch (dir) {
                    case NORTH: {
                        if (open) {
                            return NIGHT_STAND_LEFT_OPEN_EAST;
                        }
                        return NIGHT_STAND_LEFT_EAST;
                    }
                    case SOUTH: {
                        if (open) {
                            return NIGHT_STAND_LEFT_OPEN_WEST;
                        }
                        return NIGHT_STAND_LEFT_WEST;
                    }
                    case EAST: {
                        if (open) {
                            return NIGHT_STAND_LEFT_OPEN_SOUTH;
                        }
                        return NIGHT_STAND_LEFT_SOUTH;
                    }
                }
                if (open) {
                    return NIGHT_STAND_LEFT_OPEN;
                }
                return NIGHT_STAND_LEFT;
            }
        }
        switch (dir) {
            case NORTH: {
                if (open) {
                    return NIGHT_STAND_RIGHT_OPEN_EAST;
                }
                return NIGHT_STAND_RIGHT_EAST;
            }
            case SOUTH: {
                if (open) {
                    return NIGHT_STAND_RIGHT_OPEN_WEST;
                }
                return NIGHT_STAND_RIGHT_WEST;
            }
            case EAST: {
                if (open) {
                    return NIGHT_STAND_RIGHT_OPEN_SOUTH;
                }
                return NIGHT_STAND_RIGHT_SOUTH;
            }
        }
        if (open) {
            return NIGHT_STAND_RIGHT_OPEN;
        }
        return NIGHT_STAND_RIGHT;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

