/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.PlateBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CutleryBlock
extends HorizontalDirectionalBlock {
    private static final List<FurnitureBlock> CUTLERY = new ArrayList<FurnitureBlock>();
    public static final MapCodec<CutleryBlock> CODEC = CutleryBlock.simpleCodec(CutleryBlock::new);
    private static final VoxelShape FACING_NORTH = Shapes.or((VoxelShape)CutleryBlock.box((double)3.0, (double)0.0, (double)0.0, (double)11.0, (double)0.5, (double)15.5), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape FACING_SOUTH = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, FACING_NORTH);
    private static final VoxelShape FACING_EAST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, FACING_NORTH);
    private static final VoxelShape FACING_WEST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, FACING_NORTH);

    public CutleryBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        CUTLERY.add(new FurnitureBlock((Block)this, "cutlery"));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamCutlery() {
        return CUTLERY.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        switch (dir) {
            case WEST: {
                return FACING_SOUTH;
            }
            case NORTH: {
                return FACING_WEST;
            }
            case SOUTH: {
                return FACING_EAST;
            }
        }
        return FACING_NORTH;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()));
        if (block instanceof PlateBlock) {
            BlockState newState = block.defaultBlockState();
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)newState.setValue((Property)PlateBlock.CUTLERY, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            itemStack.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.DOWN;
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }
}

