/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DinnerChairBlock
extends BasicChairBlock {
    public float height = 0.36f;
    private static final List<FurnitureBlock> WOOD_DINNER_CHAIRS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DINNER_CHAIRS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape FACE_WEST = Shapes.or((VoxelShape)DinnerChairBlock.box((double)2.6, (double)12.4, (double)3.5, (double)3.9, (double)21.4, (double)12.5), (VoxelShape[])new VoxelShape[]{DinnerChairBlock.box((double)3.99, (double)8.8, (double)1.6, (double)14.99, (double)10.3, (double)14.4), DinnerChairBlock.box((double)4.0, (double)8.0, (double)1.5, (double)15.1, (double)9.0, (double)14.5), DinnerChairBlock.box((double)2.0, (double)0.0, (double)1.5, (double)4.0, (double)22.0, (double)3.5), DinnerChairBlock.box((double)12.0, (double)0.0, (double)12.5, (double)14.0, (double)8.0, (double)14.5), DinnerChairBlock.box((double)2.0, (double)0.0, (double)12.5, (double)4.0, (double)22.0, (double)14.5), DinnerChairBlock.box((double)12.0, (double)0.0, (double)1.5, (double)14.0, (double)8.0, (double)3.5)});
    protected static final VoxelShape FACE_SOUTH = DinnerChairBlock.rotateShape(Direction.WEST, Direction.SOUTH, FACE_WEST);
    protected static final VoxelShape FACE_NORTH = DinnerChairBlock.rotateShape(Direction.WEST, Direction.NORTH, FACE_WEST);
    protected static final VoxelShape FACE_EAST = DinnerChairBlock.rotateShape(Direction.WEST, Direction.EAST, FACE_WEST);
    protected static final VoxelShape FACE_NORTH_TUCKED = DinnerChairBlock.tuckShape(Direction.NORTH, FACE_NORTH);
    protected static final VoxelShape FACE_SOUTH_TUCKED = DinnerChairBlock.tuckShape(Direction.SOUTH, FACE_SOUTH);
    protected static final VoxelShape FACE_EAST_TUCKED = DinnerChairBlock.tuckShape(Direction.EAST, FACE_EAST);
    protected static final VoxelShape FACE_WEST_TUCKED = DinnerChairBlock.tuckShape(Direction.WEST, FACE_WEST);

    public DinnerChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (DinnerChairBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(DinnerChairBlock.class)) {
            WOOD_DINNER_CHAIRS.add(new FurnitureBlock(this.asBlock(), "chair_dinner"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(DinnerChairBlock.class)) {
            STONE_DINNER_CHAIRS.add(new FurnitureBlock(this.asBlock(), "chair_dinner"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodDinnerChairs() {
        return WOOD_DINNER_CHAIRS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneDinnerChairs() {
        return STONE_DINNER_CHAIRS.stream();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> FACE_WEST;
            case Direction.NORTH -> FACE_NORTH;
            case Direction.SOUTH -> FACE_SOUTH;
            default -> FACE_EAST;
        };
    }

    @Override
    public Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor() {
        return DinnerChairBlock::new;
    }
}

