/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.IronFridgeBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.FreezerBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FreezerBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private Supplier<FridgeBlock> fridge;
    private static final List<FurnitureBlock> FREEZERS = new ArrayList<FurnitureBlock>();
    protected static final Map<Direction, VoxelShape> FREEZER = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)5.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)-16.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FREEZER_SINGLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)4.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FREEZER_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)5.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)5.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)5.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)-16.0, (double)1.0, (double)15.0, (double)5.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FREEZER_SINGLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)4.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };

    public FreezerBlock(BlockBehaviour.Properties settings, Supplier<FridgeBlock> fridge) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.defaultBlockState();
        this.fridge = fridge;
        this.baseBlock = this.baseBlockState.getBlock();
        FREEZERS.add(new FurnitureBlock((Block)this, "freezer"));
    }

    public static Stream<FurnitureBlock> streamFreezers() {
        return FREEZERS.stream();
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        MenuProvider screenHandlerFactory;
        if (!world.isClientSide && (screenHandlerFactory = state.getMenuProvider(world, pos)) != null) {
            player.awardStat(Statistics.FREEZER_OPENED);
            player.openMenu(screenHandlerFactory);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{OPEN});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return super.getCloneItemStack(world, pos, state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasFridge;
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean bl = hasFridge = world.getBlockState(pos.below()).getBlock() instanceof FridgeBlock && !(world.getBlockState(pos.below()).getBlock() instanceof IronFridgeBlock);
        if (hasFridge) {
            if (open.booleanValue()) {
                if (!FREEZER_OPEN.containsKey(dir)) {
                    FREEZER_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FREEZER_OPEN.get(Direction.NORTH)));
                }
                return FREEZER_OPEN.get(dir);
            }
            if (!FREEZER.containsKey(dir)) {
                FREEZER.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FREEZER.get(Direction.NORTH)));
            }
            return FREEZER.get(dir);
        }
        if (open.booleanValue()) {
            if (!FREEZER_SINGLE_OPEN.containsKey(dir)) {
                FREEZER_SINGLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FREEZER_SINGLE_OPEN.get(Direction.NORTH)));
            }
            return FREEZER_SINGLE_OPEN.get(dir);
        }
        if (!FREEZER_SINGLE.containsKey(dir)) {
            FREEZER_SINGLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FREEZER_SINGLE.get(Direction.NORTH)));
        }
        return FREEZER_SINGLE.get(dir);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return super.canSurvive(state, world, pos);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        super.destroy(world, pos, state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return FreezerBlockEntity.getFactory().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return FreezerBlock.checkType(world, type, BlockEntities.FREEZER_BLOCK_ENTITY);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> checkType(Level world, BlockEntityType<T> givenType, BlockEntityType<? extends FreezerBlockEntity> expectedType) {
        return world.isClientSide ? null : FreezerBlock.createTickerHelper(givenType, expectedType, FreezerBlockEntity::tick);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

