/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.IronFridgeBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.FridgeBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private final Block baseBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> FRIDGES = new ArrayList<FurnitureBlock>();
    private final Supplier<FreezerBlock> freezer;
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)3.0, (double)-0.5, (double)13.0, (double)14.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)4.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)4.0, (double)-0.5, (double)13.0, (double)20.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)20.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)21.0, (double)16.0), Block.box((double)1.0, (double)21.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)3.0, (double)-10.0, (double)1.0, (double)14.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)4.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)16.0, (double)3.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)4.0, (double)-10.0, (double)1.0, (double)20.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)20.0, (double)2.0), Block.box((double)1.0, (double)20.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_FREEZER_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)20.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)20.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)32.0, (double)16.0), Block.box((double)1.0, (double)20.0, (double)1.0, (double)15.0, (double)21.0, (double)2.0)}));
        }
    };

    public FridgeBlock(BlockBehaviour.Properties settings, Supplier<FreezerBlock> freezer) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        FRIDGES.add(new FurnitureBlock((Block)this, "fridge"));
        this.freezer = freezer;
    }

    public static Stream<FurnitureBlock> streamFridges() {
        return FRIDGES.stream();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{OPEN});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return super.canSurvive(state, world, pos);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.getAxis().isVertical() && neighborState.getBlock() == this ? (neighborState.getValue((Property)FACING) == state.getValue((Property)FACING) ? (BlockState)state.setValue((Property)OPEN, (Comparable)((Boolean)neighborState.getValue((Property)OPEN))) : state) : state;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            player.openMenu((MenuProvider)((FridgeBlockEntity)blockEntity));
            player.awardStat(Statistics.FRIDGE_OPENED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide && player.isCreative()) {
            this.onBreakInCreative(world, pos, state, player);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.is((Block)this)) {
            return true;
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    public float getShadeBrightness(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasFreezer;
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean bottom = state.is(world.getBlockState(pos.above()).getBlock());
        boolean top = state.is(world.getBlockState(pos.below()).getBlock());
        boolean bl = hasFreezer = world.getBlockState(pos.above()).getBlock() instanceof FreezerBlock && !(world.getBlockState(pos.above()).getBlock() instanceof IronFridgeBlock);
        if (top && hasFreezer) {
            if (open) {
                if (!FRIDGE_MIDDLE_FREEZER_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_FREEZER_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_FREEZER_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE_FREEZER.containsKey(dir)) {
                FRIDGE_MIDDLE_FREEZER.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_FREEZER.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE_FREEZER.get(dir);
        }
        if (top && bottom) {
            if (open) {
                if (!FRIDGE_MIDDLE_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE.containsKey(dir)) {
                FRIDGE_MIDDLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE.get(dir);
        }
        if (bottom) {
            if (open) {
                if (!FRIDGE_BOTTOM_OPEN.containsKey(dir)) {
                    FRIDGE_BOTTOM_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_BOTTOM_OPEN.get(dir);
            }
            if (!FRIDGE_BOTTOM.containsKey(dir)) {
                FRIDGE_BOTTOM.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM.get(Direction.NORTH)));
            }
            return FRIDGE_BOTTOM.get(dir);
        }
        if (top) {
            if (open) {
                if (!FRIDGE_TOP_OPEN.containsKey(dir)) {
                    FRIDGE_TOP_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_TOP_OPEN.get(dir);
            }
            if (!FRIDGE_TOP.containsKey(dir)) {
                FRIDGE_TOP.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP.get(Direction.NORTH)));
            }
            return FRIDGE_TOP.get(dir);
        }
        if (hasFreezer) {
            if (open) {
                if (!FRIDGE_OPEN.containsKey(dir)) {
                    FRIDGE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_OPEN.get(dir);
            }
            if (!FRIDGE.containsKey(dir)) {
                FRIDGE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE.get(Direction.NORTH)));
            }
            return FRIDGE.get(dir);
        }
        if (open) {
            if (!FRIDGE_SINGLE_OPEN.containsKey(dir)) {
                FRIDGE_SINGLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE_OPEN.get(Direction.NORTH)));
            }
            return FRIDGE_SINGLE_OPEN.get(dir);
        }
        if (!FRIDGE_SINGLE.containsKey(dir)) {
            FRIDGE_SINGLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE.get(Direction.NORTH)));
        }
        return FRIDGE_SINGLE.get(dir);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return FridgeBlockEntity.getFactory().create(pos, state);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

