/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FroggyChairBlock
extends BasicChairBlock {
    public float height = 0.36f;
    private static final List<FurnitureBlock> FROGGY_CHAIRS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape FACE_WEST = Shapes.or((VoxelShape)FroggyChairBlock.box((double)0.8, (double)9.5, (double)2.6, (double)2.6, (double)19.5, (double)13.6), (VoxelShape[])new VoxelShape[]{FroggyChairBlock.box((double)0.8, (double)17.5, (double)10.6, (double)2.6, (double)21.5, (double)14.6), FroggyChairBlock.box((double)0.8, (double)17.5, (double)1.6, (double)2.6, (double)21.5, (double)5.6), FroggyChairBlock.box((double)0.8, (double)8.0, (double)2.6, (double)13.3, (double)9.5, (double)13.6), FroggyChairBlock.box((double)12.0, (double)0.0, (double)1.5, (double)14.0, (double)8.0, (double)3.5), FroggyChairBlock.box((double)11.5, (double)6.5, (double)2.5, (double)13.5, (double)8.0, (double)4.5), FroggyChairBlock.box((double)11.5, (double)6.5, (double)11.5, (double)13.5, (double)8.0, (double)13.5), FroggyChairBlock.box((double)12.0, (double)0.0, (double)12.5, (double)14.0, (double)8.0, (double)14.5), FroggyChairBlock.box((double)1.5, (double)6.5, (double)11.0, (double)3.5, (double)8.0, (double)13.0), FroggyChairBlock.box((double)0.5, (double)0.0, (double)12.5, (double)2.5, (double)8.0, (double)14.5), FroggyChairBlock.box((double)0.5, (double)0.0, (double)1.5, (double)2.5, (double)8.0, (double)3.5), FroggyChairBlock.box((double)1.5, (double)6.5, (double)2.5, (double)3.5, (double)8.0, (double)4.5)});
    protected static final VoxelShape FACE_SOUTH = FroggyChairBlock.rotateShape(Direction.WEST, Direction.SOUTH, FACE_WEST);
    protected static final VoxelShape FACE_NORTH = FroggyChairBlock.rotateShape(Direction.WEST, Direction.NORTH, FACE_WEST);
    protected static final VoxelShape FACE_EAST = FroggyChairBlock.rotateShape(Direction.WEST, Direction.EAST, FACE_WEST);
    protected static final VoxelShape FACE_NORTH_TUCKED = FroggyChairBlock.tuckShape(Direction.NORTH, FACE_NORTH);
    protected static final VoxelShape FACE_SOUTH_TUCKED = FroggyChairBlock.tuckShape(Direction.SOUTH, FACE_SOUTH);
    protected static final VoxelShape FACE_EAST_TUCKED = FroggyChairBlock.tuckShape(Direction.EAST, FACE_EAST);
    protected static final VoxelShape FACE_WEST_TUCKED = FroggyChairBlock.tuckShape(Direction.WEST, FACE_WEST);

    public FroggyChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (((Object)((Object)this)).getClass().isAssignableFrom(FroggyChairBlock.class)) {
            FROGGY_CHAIRS.add(new FurnitureBlock((Block)this, "froggy_chair_"));
        }
    }

    public static Stream<FurnitureBlock> streamFroggyChair() {
        return FROGGY_CHAIRS.stream();
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> FACE_WEST;
            case Direction.NORTH -> FACE_NORTH;
            case Direction.SOUTH -> FACE_SOUTH;
            default -> FACE_EAST;
        };
    }

    @Override
    public Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor() {
        return FroggyChairBlock::new;
    }
}

