/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.FridgeBlock;
import com.unlikepaladin.pfm.blocks.IronFreezerBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IronFridgeBlock
extends FridgeBlock {
    private Supplier<FreezerBlock> freezer;
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)2.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)0.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0)));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)2.0, (double)-0.5, (double)13.0, (double)16.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)12.0, (double)1.0, (double)-0.5, (double)13.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)2.0), Block.box((double)1.0, (double)-16.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_SINGLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)2.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_TOP_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_MIDDLE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)0.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)-12.0, (double)3.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_BOTTOM_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)-0.5, (double)2.0, (double)-10.0, (double)1.0, (double)16.0, (double)-9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)3.0), Block.box((double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)16.0)}));
        }
    };
    protected static final Map<Direction, VoxelShape> FRIDGE_OPEN = new HashMap<Direction, VoxelShape>(){
        {
            this.put(Direction.NORTH, Shapes.or((VoxelShape)Block.box((double)1.0, (double)1.0, (double)-12.0, (double)3.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)-0.5, (double)1.0, (double)-10.0, (double)1.0, (double)15.0, (double)-9.0), Block.box((double)2.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)2.0), Block.box((double)1.0, (double)-16.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0)}));
        }
    };

    public IronFridgeBlock(BlockBehaviour.Properties settings, Supplier<FreezerBlock> freezer) {
        super(settings, freezer);
        this.freezer = freezer;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = ((Direction)state.getValue((Property)FACING)).getOpposite();
        Boolean open = (Boolean)state.getValue((Property)OPEN);
        boolean bottom = state.is(world.getBlockState(pos.above()).getBlock());
        boolean top = state.is(world.getBlockState(pos.below()).getBlock());
        boolean hasFreezer = world.getBlockState(pos.below()).getBlock() instanceof IronFreezerBlock;
        if (top && bottom) {
            if (open.booleanValue()) {
                if (!FRIDGE_MIDDLE_OPEN.containsKey(dir)) {
                    FRIDGE_MIDDLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_MIDDLE_OPEN.get(dir);
            }
            if (!FRIDGE_MIDDLE.containsKey(dir)) {
                FRIDGE_MIDDLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_MIDDLE.get(Direction.NORTH)));
            }
            return FRIDGE_MIDDLE.get(dir);
        }
        if (bottom) {
            if (open.booleanValue()) {
                if (!FRIDGE_BOTTOM_OPEN.containsKey(dir)) {
                    FRIDGE_BOTTOM_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_BOTTOM_OPEN.get(dir);
            }
            if (!FRIDGE_BOTTOM.containsKey(dir)) {
                FRIDGE_BOTTOM.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_BOTTOM.get(Direction.NORTH)));
            }
            return FRIDGE_BOTTOM.get(dir);
        }
        if (top) {
            if (open.booleanValue()) {
                if (!FRIDGE_TOP_OPEN.containsKey(dir)) {
                    FRIDGE_TOP_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_TOP_OPEN.get(dir);
            }
            if (!FRIDGE_TOP.containsKey(dir)) {
                FRIDGE_TOP.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_TOP.get(Direction.NORTH)));
            }
            return FRIDGE_TOP.get(dir);
        }
        if (hasFreezer) {
            if (open.booleanValue()) {
                if (!FRIDGE_OPEN.containsKey(dir)) {
                    FRIDGE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_OPEN.get(Direction.NORTH)));
                }
                return FRIDGE_OPEN.get(dir);
            }
            if (!FRIDGE.containsKey(dir)) {
                FRIDGE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE.get(Direction.NORTH)));
            }
            return FRIDGE.get(dir);
        }
        if (open.booleanValue()) {
            if (!FRIDGE_SINGLE_OPEN.containsKey(dir)) {
                FRIDGE_SINGLE_OPEN.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE_OPEN.get(Direction.NORTH)));
            }
            return FRIDGE_SINGLE_OPEN.get(dir);
        }
        if (!FRIDGE_SINGLE.containsKey(dir)) {
            FRIDGE_SINGLE.put(dir, KitchenDrawerBlock.rotateShape(Direction.NORTH, dir, FRIDGE_SINGLE.get(Direction.NORTH)));
        }
        return FRIDGE_SINGLE.get(dir);
    }

    @Override
    public void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return super.canSurvive(state, world, pos);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        super.destroy(world, pos, state);
    }
}

