/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity9x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenCabinetBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private final BlockState baseBlockState;
    private final Block baseBlock;
    private static final List<FurnitureBlock> WOOD_CABINETS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CABINETS = new ArrayList<FurnitureBlock>();
    public static final MapCodec<KitchenCabinetBlock> CODEC = KitchenCabinetBlock.simpleCodec(KitchenCabinetBlock::new);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape STRAIGHT = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)0.0, (double)1.0, (double)8.0, (double)16.0, (double)16.0, (double)9.0), KitchenCabinetBlock.box((double)6.0, (double)3.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0), KitchenCabinetBlock.box((double)9.0, (double)3.0, (double)9.0, (double)10.0, (double)7.0, (double)10.0)});
    protected static final VoxelShape INNER_CORNER = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)1.0, (double)3.0, (double)9.0, (double)2.0, (double)7.0, (double)10.0), KitchenCabinetBlock.box((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)16.0, (double)9.0), KitchenCabinetBlock.box((double)7.0, (double)1.0, (double)9.0, (double)8.0, (double)16.0, (double)16.0), KitchenCabinetBlock.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.box((double)6.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0, (double)14.0)});
    protected static final VoxelShape OUTER_CORNER = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)6.0, (double)3.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0), KitchenCabinetBlock.box((double)0.0, (double)1.0, (double)8.0, (double)8.0, (double)16.0, (double)9.0), KitchenCabinetBlock.box((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0), KitchenCabinetBlock.box((double)9.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)7.0)});
    protected static final VoxelShape STRAIGHT_OPEN = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)16.0, (double)3.0, (double)14.0, (double)17.0, (double)7.0, (double)15.0), KitchenCabinetBlock.box((double)15.0, (double)1.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.box((double)-1.0, (double)3.0, (double)14.0, (double)0.0, (double)7.0, (double)15.0), KitchenCabinetBlock.box((double)0.0, (double)1.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape INNER_CORNER_OPEN = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)7.0, (double)1.0, (double)9.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), KitchenCabinetBlock.box((double)6.0, (double)3.0, (double)13.0, (double)7.0, (double)7.0, (double)14.0), KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)});
    protected static final VoxelShape OUTER_CORNER_OPEN = Shapes.or((VoxelShape)KitchenCabinetBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{KitchenCabinetBlock.box((double)0.0, (double)1.0, (double)8.0, (double)1.0, (double)16.0, (double)16.0), KitchenCabinetBlock.box((double)-1.0, (double)3.0, (double)14.0, (double)0.0, (double)7.0, (double)15.0), KitchenCabinetBlock.box((double)8.0, (double)1.0, (double)0.0, (double)9.0, (double)16.0, (double)8.0), KitchenCabinetBlock.box((double)9.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)7.0)});
    protected static final VoxelShape STRAIGHT_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT);
    protected static final VoxelShape STRAIGHT_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT_OPEN);
    protected static final VoxelShape INNER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER_OPEN);
    protected static final VoxelShape INNER_CORNER_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER_OPEN);
    protected static final VoxelShape INNER_CORNER_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_OPEN_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_OPEN_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_OPEN_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER_OPEN);

    public KitchenCabinetBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenCabinetBlock.class)) {
            WOOD_CABINETS.add(new FurnitureBlock((Block)this, "kitchen_cabinet"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenCabinetBlock.class)) {
            STONE_CABINETS.add(new FurnitureBlock((Block)this, "kitchen_cabinet"));
        }
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodCabinets() {
        return WOOD_CABINETS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneCabinets() {
        return STONE_CABINETS.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{OPEN});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)KitchenCounterBlock.FACING);
        BlockState neighborStateFacing = view.getBlockState(pos.relative(direction));
        BlockState neighborStateOpposite = view.getBlockState(pos.relative(direction.getOpposite()));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (this.isCabinet(neighborStateFacing) && neighborStateFacing.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction2.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, view, pos, direction2.getOpposite())) {
                if (direction2 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN;
                            }
                            return OUTER_CORNER;
                        }
                        case SOUTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN_SOUTH;
                            }
                            return OUTER_CORNER_SOUTH;
                        }
                        case EAST: {
                            if (open) {
                                return OUTER_CORNER_OPEN_EAST;
                            }
                            return OUTER_CORNER_EAST;
                        }
                    }
                    if (open) {
                        return OUTER_CORNER_OPEN_WEST;
                    }
                    return OUTER_CORNER_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_EAST;
                        }
                        return OUTER_CORNER_EAST;
                    }
                    case SOUTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_WEST;
                        }
                        return OUTER_CORNER_WEST;
                    }
                    case EAST: {
                        if (open) {
                            return OUTER_CORNER_OPEN_SOUTH;
                        }
                        return OUTER_CORNER_SOUTH;
                    }
                }
                if (open) {
                    return OUTER_CORNER_OPEN;
                }
                return OUTER_CORNER;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        if (this.isCabinet(neighborStateOpposite) && neighborStateOpposite.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction3.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, view, pos, direction3)) {
                if (direction3 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_CORNER_WEST;
                        }
                        case SOUTH: {
                            return INNER_CORNER_EAST;
                        }
                        case EAST: {
                            return INNER_CORNER;
                        }
                    }
                    return INNER_CORNER_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_CORNER;
                    }
                    case SOUTH: {
                        return INNER_CORNER_SOUTH;
                    }
                    case EAST: {
                        return INNER_CORNER_EAST;
                    }
                }
                return INNER_CORNER_WEST;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        switch (direction) {
            case NORTH: {
                if (open) {
                    return STRAIGHT_OPEN;
                }
                return STRAIGHT;
            }
            case SOUTH: {
                if (open) {
                    return STRAIGHT_OPEN_SOUTH;
                }
                return STRAIGHT_SOUTH;
            }
            case EAST: {
                if (open) {
                    return STRAIGHT_OPEN_EAST;
                }
                return STRAIGHT_EAST;
            }
        }
        if (open) {
            return STRAIGHT_OPEN_WEST;
        }
        return STRAIGHT_WEST;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public boolean isCabinet(BlockState state) {
        return state.getBlock() instanceof KitchenCabinetBlock;
    }

    public boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos.relative(dir));
        return !this.isCabinet(blockState);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GenericStorageBlockEntity9x3) {
            player.openMenu((MenuProvider)((GenericStorageBlockEntity9x3)blockEntity));
            player.awardStat(Statistics.CABINET_SEARCHED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity9x3.getFactory().create(pos, state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

