/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenCounterBlock
extends HorizontalDirectionalBlock {
    private float height = 0.36f;
    private final Block baseBlock;
    protected FurnitureBlock counterFurnitureBlock;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_COUNTERS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_COUNTERS = new ArrayList<FurnitureBlock>();
    public static final MapCodec<KitchenCounterBlock> CODEC = KitchenCounterBlock.simpleCodec(KitchenCounterBlock::new);
    protected static final VoxelShape STRAIGHT = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape INNER_CORNER = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.box((double)3.0, (double)1.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0)});
    protected static final VoxelShape OUTER_CORNER = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.box((double)0.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)13.0), KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)12.0)});
    protected static final VoxelShape LEFT_EDGE = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.box((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), KitchenCounterBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape RIGHT_EDGE = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenCounterBlock.box((double)0.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0), KitchenCounterBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenCounterBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    protected static final VoxelShape MIDDLE = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape INNER_MIDDLE = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)KitchenCounterBlock.box((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0));
    protected static final VoxelShape OUTER_MIDDLE = Shapes.or((VoxelShape)KitchenCounterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE);
    protected static final VoxelShape MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE);
    protected static final VoxelShape MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_MIDDLE);
    protected static final VoxelShape INNER_MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_MIDDLE);
    protected static final VoxelShape OUTER_MIDDLE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_MIDDLE);
    protected static final VoxelShape STRAIGHT_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT);
    protected static final VoxelShape STRAIGHT_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT);
    protected static final VoxelShape INNER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER);
    protected static final VoxelShape OUTER_CORNER_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER);
    protected static final VoxelShape LEFT_EDGE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, LEFT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_SOUTH = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_EAST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.EAST, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_WEST = KitchenCounterBlock.rotateShape(Direction.NORTH, Direction.WEST, RIGHT_EDGE);

    public KitchenCounterBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        this.counterFurnitureBlock = new FurnitureBlock((Block)this, "kitchen_counter");
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenCounterBlock.class)) {
            WOOD_COUNTERS.add(this.counterFurnitureBlock);
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenCounterBlock.class)) {
            STONE_COUNTERS.add(this.counterFurnitureBlock);
        }
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodCounters() {
        return WOOD_COUNTERS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneCounters() {
        return STONE_COUNTERS.stream();
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public boolean canConnect(BlockGetter world, BlockPos pos, Direction direction) {
        BlockState state = world.getBlockState(pos.relative(direction));
        return this.isCounter(state) || state.getBlock() instanceof AbstractFurnaceBlock || state.getBlock() instanceof AbstractCauldronBlock || KitchenCounterBlock.isCookingForBlockHeadsBlock(state.getBlock().getDescriptionId());
    }

    public static boolean isCookingForBlockHeadsBlock(String key) {
        return key.contains("cookingforblockheads") && (key.contains("cooking_table") || key.contains("oven") || key.contains("sink") || key.contains("corner") || key.contains("cabinet") || key.contains("counter"));
    }

    public boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos.relative(dir));
        return !this.canConnectToCounter(blockState);
    }

    public boolean canConnectToCounter(BlockState state) {
        return this.isCounter(state) || state.getBlock() instanceof AbstractFurnaceBlock || state.getBlock() instanceof AbstractCauldronBlock || KitchenCounterBlock.isCookingForBlockHeadsBlock(state.getBlock().getDescriptionId());
    }

    public boolean isCounter(BlockState state) {
        boolean doDifferentCountersConnect = PaladinFurnitureMod.getPFMConfig().doCountersOfDifferentMaterialsConnect() ? state.getBlock() instanceof KitchenCounterBlock : (state.getBlock() instanceof KitchenCounterBlock ? this.counterFurnitureBlock.getBaseMaterial() == ((KitchenCounterBlock)state.getBlock()).counterFurnitureBlock.getBaseMaterial() : false);
        return doDifferentCountersConnect || state.getBlock() instanceof KitchenWallCounterBlock || state.getBlock() instanceof KitchenWallDrawerBlock;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        boolean right = this.canConnect(world, pos, ((Direction)state.getValue((Property)FACING)).getCounterClockWise());
        boolean left = this.canConnect(world, pos, ((Direction)state.getValue((Property)FACING)).getClockWise());
        BlockState neighborStateFacing = world.getBlockState(pos.relative(direction));
        BlockState neighborStateOpposite = world.getBlockState(pos.relative(direction.getOpposite()));
        if (this.canConnectToCounter(neighborStateFacing) && neighborStateFacing.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction2.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, direction2.getOpposite())) {
                if (direction2 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return OUTER_CORNER;
                        }
                        case SOUTH: {
                            return OUTER_CORNER_SOUTH;
                        }
                        case EAST: {
                            return OUTER_CORNER_EAST;
                        }
                    }
                    return OUTER_CORNER_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        return OUTER_CORNER_EAST;
                    }
                    case SOUTH: {
                        return OUTER_CORNER_WEST;
                    }
                    case EAST: {
                        return OUTER_CORNER_SOUTH;
                    }
                }
                return OUTER_CORNER;
            }
            return this.getMiddleShape(direction, left, right);
        }
        if (this.canConnectToCounter(neighborStateOpposite) && neighborStateOpposite.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction3.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, direction3)) {
                if (direction3 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_CORNER_WEST;
                        }
                        case SOUTH: {
                            return INNER_CORNER_EAST;
                        }
                        case EAST: {
                            return INNER_CORNER;
                        }
                    }
                    return INNER_CORNER_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_CORNER;
                    }
                    case SOUTH: {
                        return INNER_CORNER_SOUTH;
                    }
                    case EAST: {
                        return INNER_CORNER_EAST;
                    }
                }
                return INNER_CORNER_WEST;
            }
            return this.getMiddleShape(direction, left, right);
        }
        return this.getMiddleShape(direction, left, right);
    }

    private VoxelShape getMiddleShape(Direction direction, boolean left, boolean right) {
        if (left && right) {
            switch (direction) {
                case NORTH: {
                    return STRAIGHT;
                }
                case SOUTH: {
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    return STRAIGHT_EAST;
                }
            }
            return STRAIGHT_WEST;
        }
        if (left) {
            switch (direction) {
                case NORTH: {
                    return LEFT_EDGE;
                }
                case SOUTH: {
                    return LEFT_EDGE_SOUTH;
                }
                case EAST: {
                    return LEFT_EDGE_EAST;
                }
            }
            return LEFT_EDGE_WEST;
        }
        if (right) {
            switch (direction) {
                case NORTH: {
                    return RIGHT_EDGE;
                }
                case SOUTH: {
                    return RIGHT_EDGE_SOUTH;
                }
                case EAST: {
                    return RIGHT_EDGE_EAST;
                }
            }
            return RIGHT_EDGE_WEST;
        }
        switch (direction) {
            case NORTH: {
                return STRAIGHT;
            }
            case SOUTH: {
                return STRAIGHT_SOUTH;
            }
            case EAST: {
                return STRAIGHT_EAST;
            }
        }
        return STRAIGHT_WEST;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }
}

