/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.blockentities.GenericStorageBlockEntity9x3;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenDrawerBlock
extends KitchenCounterBlock
implements EntityBlock {
    private float height = 0.36f;
    private final Block baseBlock;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private final BlockState baseBlockState = this.defaultBlockState();
    private static final List<FurnitureBlock> WOOD_DRAWERS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DRAWERS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape STRAIGHT = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)12.0, (double)15.0, (double)13.0, (double)14.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)6.0, (double)4.0, (double)14.0, (double)10.0, (double)5.0, (double)15.0), KitchenDrawerBlock.box((double)6.0, (double)10.0, (double)14.0, (double)10.0, (double)11.0, (double)15.0)});
    protected static final VoxelShape STRAIGHT_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)6.0, (double)10.0, (double)19.0, (double)10.0, (double)11.0, (double)20.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)13.0, (double)15.0, (double)13.0, (double)19.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)6.0, (double)4.0, (double)14.0, (double)10.0, (double)5.0, (double)15.0)});
    protected static final VoxelShape OUTER_CORNER_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)5.0, (double)10.0, (double)19.0, (double)8.0, (double)11.0, (double)20.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)13.0, (double)12.0, (double)13.0, (double)19.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)12.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)5.0, (double)4.0, (double)14.0, (double)8.0, (double)5.0, (double)15.0), KitchenDrawerBlock.box((double)12.0, (double)8.0, (double)1.0, (double)14.0, (double)13.0, (double)12.0), KitchenDrawerBlock.box((double)12.0, (double)2.0, (double)1.0, (double)14.0, (double)7.0, (double)12.0), KitchenDrawerBlock.box((double)14.0, (double)4.0, (double)5.0, (double)15.0, (double)5.0, (double)8.0), KitchenDrawerBlock.box((double)14.0, (double)10.0, (double)5.0, (double)15.0, (double)11.0, (double)8.0)});
    protected static final VoxelShape OUTER_CORNER = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)5.0, (double)10.0, (double)14.0, (double)8.0, (double)11.0, (double)15.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)13.0, (double)12.0, (double)13.0, (double)14.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)12.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)5.0, (double)4.0, (double)14.0, (double)8.0, (double)5.0, (double)15.0), KitchenDrawerBlock.box((double)12.0, (double)8.0, (double)1.0, (double)14.0, (double)13.0, (double)12.0), KitchenDrawerBlock.box((double)12.0, (double)2.0, (double)1.0, (double)14.0, (double)7.0, (double)12.0), KitchenDrawerBlock.box((double)14.0, (double)4.0, (double)5.0, (double)15.0, (double)5.0, (double)8.0), KitchenDrawerBlock.box((double)14.0, (double)10.0, (double)5.0, (double)15.0, (double)11.0, (double)8.0)});
    protected static final VoxelShape INNER_CORNER = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)11.9), KitchenDrawerBlock.box((double)3.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)3.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)3.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0), KitchenDrawerBlock.box((double)2.0, (double)8.0, (double)14.0, (double)13.0, (double)13.0, (double)15.0)});
    protected static final VoxelShape RIGHT_EDGE = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)12.0, (double)13.0, (double)13.0, (double)14.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)13.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)6.0, (double)4.0, (double)14.0, (double)9.0, (double)5.0, (double)15.0), KitchenDrawerBlock.box((double)6.0, (double)10.0, (double)14.0, (double)9.0, (double)11.0, (double)15.0)});
    protected static final VoxelShape LEFT_EDGE = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenDrawerBlock.box((double)3.0, (double)8.0, (double)12.0, (double)15.0, (double)13.0, (double)14.0), KitchenDrawerBlock.box((double)3.0, (double)2.0, (double)12.0, (double)15.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)8.0, (double)4.0, (double)14.0, (double)11.0, (double)5.0, (double)15.0), KitchenDrawerBlock.box((double)8.0, (double)10.0, (double)14.0, (double)11.0, (double)11.0, (double)15.0)});
    protected static final VoxelShape RIGHT_EDGE_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)12.0), KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)0.0, (double)14.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)6.0, (double)10.0, (double)19.0, (double)10.0, (double)11.0, (double)20.0), KitchenDrawerBlock.box((double)1.0, (double)8.0, (double)13.0, (double)13.0, (double)13.0, (double)19.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)13.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)6.0, (double)4.0, (double)14.0, (double)10.0, (double)5.0, (double)15.0)});
    protected static final VoxelShape LEFT_EDGE_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0), KitchenDrawerBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), KitchenDrawerBlock.box((double)2.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)13.0), KitchenDrawerBlock.box((double)8.0, (double)10.0, (double)19.0, (double)12.0, (double)11.0, (double)20.0), KitchenDrawerBlock.box((double)3.0, (double)8.0, (double)13.0, (double)15.0, (double)13.0, (double)19.0), KitchenDrawerBlock.box((double)3.0, (double)2.0, (double)12.0, (double)15.0, (double)7.0, (double)14.0), KitchenDrawerBlock.box((double)8.0, (double)4.0, (double)14.0, (double)12.0, (double)5.0, (double)15.0)});
    protected static final VoxelShape STRAIGHT_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT);
    protected static final VoxelShape STRAIGHT_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, STRAIGHT_OPEN);
    protected static final VoxelShape STRAIGHT_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT);
    protected static final VoxelShape STRAIGHT_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, STRAIGHT_OPEN);
    protected static final VoxelShape INNER_CORNER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, INNER_CORNER);
    protected static final VoxelShape INNER_CORNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, INNER_CORNER);
    protected static final VoxelShape OUTER_CORNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, OUTER_CORNER_OPEN);
    protected static final VoxelShape OUTER_CORNER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER);
    protected static final VoxelShape OUTER_CORNER_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, OUTER_CORNER_OPEN);
    protected static final VoxelShape LEFT_EDGE_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, LEFT_EDGE_OPEN);
    protected static final VoxelShape LEFT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, LEFT_EDGE_OPEN);
    protected static final VoxelShape LEFT_EDGE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, LEFT_EDGE_OPEN);
    protected static final VoxelShape LEFT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, LEFT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RIGHT_EDGE_OPEN);
    protected static final VoxelShape RIGHT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RIGHT_EDGE_OPEN);
    protected static final VoxelShape RIGHT_EDGE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RIGHT_EDGE_OPEN);
    protected static final VoxelShape RIGHT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, RIGHT_EDGE);
    protected static final VoxelShape MIDDLE = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)6.0, (double)15.0), KitchenDrawerBlock.box((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)14.0)});
    protected static final VoxelShape MIDDLE_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)1.0, (double)1.0, (double)13.0, (double)2.0, (double)15.0, (double)27.0), KitchenDrawerBlock.box((double)0.0, (double)2.0, (double)25.0, (double)1.0, (double)6.0, (double)26.0)});
    protected static final VoxelShape MIDDLE_OUTER_CORNER_OPEN = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.75, (double)2.0, (double)15.0, (double)23.75), KitchenDrawerBlock.box((double)0.0, (double)2.5, (double)21.75, (double)1.0, (double)6.5, (double)22.75), KitchenDrawerBlock.box((double)13.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)12.0), KitchenDrawerBlock.box((double)14.0, (double)2.5, (double)10.0, (double)15.0, (double)6.5, (double)11.0)});
    protected static final VoxelShape MIDDLE_OUTER_CORNER = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)13.0, (double)2.0, (double)1.0, (double)14.0, (double)15.0, (double)12.0), KitchenDrawerBlock.box((double)14.0, (double)2.5, (double)10.0, (double)15.0, (double)6.5, (double)11.0), KitchenDrawerBlock.box((double)1.0, (double)2.0, (double)12.0, (double)12.0, (double)15.0, (double)14.0), KitchenDrawerBlock.box((double)10.0, (double)2.5, (double)14.0, (double)11.0, (double)6.5, (double)15.0)});
    protected static final VoxelShape MIDDLE_INNER_CORNER = Shapes.or((VoxelShape)KitchenDrawerBlock.box((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{KitchenDrawerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), KitchenDrawerBlock.box((double)2.0, (double)1.0, (double)14.0, (double)3.0, (double)15.0, (double)16.0), KitchenDrawerBlock.box((double)0.0, (double)1.0, (double)13.0, (double)3.0, (double)15.0, (double)14.0)});
    protected static final VoxelShape MIDDLE_INNER_CORNER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE_INNER_CORNER);
    protected static final VoxelShape MIDDLE_INNER_CORNER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE_INNER_CORNER);
    protected static final VoxelShape MIDDLE_INNER_CORNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE_INNER_CORNER);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE_OUTER_CORNER);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE_OUTER_CORNER);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE_OUTER_CORNER);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE_OUTER_CORNER_OPEN);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE_OUTER_CORNER_OPEN);
    protected static final VoxelShape MIDDLE_OUTER_CORNER_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE_OUTER_CORNER_OPEN);
    protected static final VoxelShape MIDDLE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE);
    protected static final VoxelShape MIDDLE_OPEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, MIDDLE_OPEN);
    protected static final VoxelShape MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE);
    protected static final VoxelShape MIDDLE_OPEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, MIDDLE_OPEN);
    protected static final VoxelShape MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE);
    protected static final VoxelShape MIDDLE_OPEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MIDDLE_OPEN);

    public KitchenDrawerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.baseBlock = this.baseBlockState.getBlock();
        if (!(this.baseBlock instanceof KitchenWallDrawerSmallBlock)) {
            this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        }
        this.counterFurnitureBlock = new FurnitureBlock((Block)this, "kitchen_drawer");
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenDrawerBlock.class)) {
            WOOD_DRAWERS.add(this.counterFurnitureBlock);
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenDrawerBlock.class)) {
            STONE_DRAWERS.add(this.counterFurnitureBlock);
        }
    }

    public static Stream<FurnitureBlock> streamWoodDrawers() {
        return WOOD_DRAWERS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneDrawers() {
        return STONE_DRAWERS.stream();
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    @Override
    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{OPEN});
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof GenericStorageBlockEntity9x3) {
            player.openMenu((MenuProvider)((GenericStorageBlockEntity9x3)blockEntity));
            player.awardStat(Statistics.DRAWER_SEARCHED);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!state.is(state.getBlock())) {
            oldState.handleNeighborChanged(world, pos, Blocks.AIR, pos, false);
        }
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)KitchenCounterBlock.FACING);
        boolean right = this.canConnect(world, pos, ((Direction)state.getValue((Property)KitchenCounterBlock.FACING)).getCounterClockWise());
        boolean left = this.canConnect(world, pos, ((Direction)state.getValue((Property)KitchenCounterBlock.FACING)).getClockWise());
        BlockState neighborStateFacing = world.getBlockState(pos.relative(direction));
        BlockState neighborStateOpposite = world.getBlockState(pos.relative(direction.getOpposite()));
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (this.canConnectToCounter(neighborStateFacing) && neighborStateFacing.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction2 = (Direction)neighborStateFacing.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction2.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, direction2.getOpposite())) {
                if (direction2 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN;
                            }
                            return OUTER_CORNER;
                        }
                        case SOUTH: {
                            if (open) {
                                return OUTER_CORNER_OPEN_SOUTH;
                            }
                            return OUTER_CORNER_SOUTH;
                        }
                        case EAST: {
                            if (open) {
                                return OUTER_CORNER_OPEN_EAST;
                            }
                            return OUTER_CORNER_EAST;
                        }
                    }
                    if (open) {
                        return OUTER_CORNER_OPEN_WEST;
                    }
                    return OUTER_CORNER_WEST;
                }
                switch (direction) {
                    case NORTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_EAST;
                        }
                        return OUTER_CORNER_EAST;
                    }
                    case SOUTH: {
                        if (open) {
                            return OUTER_CORNER_OPEN_WEST;
                        }
                        return OUTER_CORNER_WEST;
                    }
                    case EAST: {
                        if (open) {
                            return OUTER_CORNER_OPEN_SOUTH;
                        }
                        return OUTER_CORNER_SOUTH;
                    }
                }
                if (open) {
                    return OUTER_CORNER_OPEN;
                }
                return OUTER_CORNER;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        if (this.canConnectToCounter(neighborStateOpposite) && neighborStateOpposite.getProperties().contains(BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction3 = neighborStateOpposite.getBlock() instanceof AbstractFurnaceBlock ? ((Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite() : (Direction)neighborStateOpposite.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (direction3.getAxis() != ((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, direction3)) {
                if (direction3 == direction.getCounterClockWise()) {
                    switch (direction) {
                        case NORTH: {
                            return INNER_CORNER_WEST;
                        }
                        case SOUTH: {
                            return INNER_CORNER_EAST;
                        }
                        case EAST: {
                            return INNER_CORNER;
                        }
                    }
                    return INNER_CORNER_SOUTH;
                }
                switch (direction) {
                    case NORTH: {
                        return INNER_CORNER;
                    }
                    case SOUTH: {
                        return INNER_CORNER_SOUTH;
                    }
                    case EAST: {
                        return INNER_CORNER_EAST;
                    }
                }
                return INNER_CORNER_WEST;
            }
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        if (left && right) {
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return STRAIGHT_OPEN;
                    }
                    return STRAIGHT;
                }
                case SOUTH: {
                    if (open) {
                        return STRAIGHT_OPEN_SOUTH;
                    }
                    return STRAIGHT_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return STRAIGHT_OPEN_EAST;
                    }
                    return STRAIGHT_EAST;
                }
            }
            if (open) {
                return STRAIGHT_OPEN_WEST;
            }
            return STRAIGHT_WEST;
        }
        if (left) {
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return LEFT_EDGE_OPEN;
                    }
                    return LEFT_EDGE;
                }
                case SOUTH: {
                    if (open) {
                        return LEFT_EDGE_OPEN_SOUTH;
                    }
                    return LEFT_EDGE_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return LEFT_EDGE_OPEN_EAST;
                    }
                    return LEFT_EDGE_EAST;
                }
            }
            if (open) {
                return LEFT_EDGE_OPEN_WEST;
            }
            return LEFT_EDGE_WEST;
        }
        if (right) {
            switch (direction) {
                case NORTH: {
                    if (open) {
                        return RIGHT_EDGE_OPEN;
                    }
                    return RIGHT_EDGE;
                }
                case SOUTH: {
                    if (open) {
                        return RIGHT_EDGE_OPEN_SOUTH;
                    }
                    return RIGHT_EDGE_SOUTH;
                }
                case EAST: {
                    if (open) {
                        return RIGHT_EDGE_OPEN_EAST;
                    }
                    return RIGHT_EDGE_EAST;
                }
            }
            if (open) {
                return RIGHT_EDGE_OPEN_WEST;
            }
            return RIGHT_EDGE_WEST;
        }
        switch (direction) {
            case NORTH: {
                if (open) {
                    return STRAIGHT_OPEN;
                }
                return STRAIGHT;
            }
            case SOUTH: {
                if (open) {
                    return STRAIGHT_OPEN_SOUTH;
                }
                return STRAIGHT_SOUTH;
            }
            case EAST: {
                if (open) {
                    return STRAIGHT_OPEN_EAST;
                }
                return STRAIGHT_EAST;
            }
        }
        if (open) {
            return STRAIGHT_OPEN_WEST;
        }
        return STRAIGHT_WEST;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return GenericStorageBlockEntity9x3.getFactory().create(pos, state);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }
}

